/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dshuds.proxy;

import java.util.Arrays;
import javax.annotation.Nonnull;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.ModMetadata;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.StringUtils;
import org.orecruncher.dshuds.hud.LightLevelHUD;
import org.orecruncher.dshuds.keyboard.KeyHandler;
import org.orecruncher.dshuds.proxy.Proxy;
import org.orecruncher.lib.ForgeUtils;
import org.orecruncher.lib.Localization;
import org.orecruncher.lib.task.Scheduler;

@SideOnly(value=Side.CLIENT)
public class ProxyClient
extends Proxy {
    @Override
    public boolean isRunningAsServer() {
        return false;
    }

    @Override
    public Side effectiveSide() {
        return FMLCommonHandler.instance().getEffectiveSide();
    }

    @Override
    public void preInit(@Nonnull FMLPreInitializationEvent event) {
        Localization.initialize((Side)Side.CLIENT, (String)"dshuds");
        KeyHandler.init();
    }

    @Override
    public void postInit(@Nonnull FMLPostInitializationEvent event) {
        ModMetadata data = ForgeUtils.getModMetadata((String)"dshuds");
        if (data != null) {
            data.name = Localization.loadString((String)"dshuds.metadata.Name");
            data.credits = Localization.loadString((String)"dshuds.metadata.Credits");
            data.description = Localization.loadString((String)"dshuds.metadata.Description");
            data.authorList = Arrays.asList(StringUtils.split((String)Localization.loadString((String)"dshuds.metadata.Authors"), (char)','));
        }
        LightLevelHUD.initialize();
    }

    @Override
    public void clientConnect(@Nonnull FMLNetworkEvent.ClientConnectedToServerEvent event) {
        Scheduler.schedule((Side)Side.CLIENT, () -> {
            this.connectionTime = System.currentTimeMillis();
        });
    }

    @Override
    public void clientDisconnect(@Nonnull FMLNetworkEvent.ClientDisconnectionFromServerEvent event) {
        Scheduler.schedule((Side)Side.CLIENT, () -> {
            this.connectionTime = 0L;
        });
    }
}

