/*
 * Decompiled with CFR 0.152.
 */
package com.charles445.rltweaker.command;

import com.charles445.rltweaker.RLTweaker;
import com.charles445.rltweaker.config.ModConfig;
import com.charles445.rltweaker.config.annotation.RLConfig;
import com.charles445.rltweaker.config.annotation.SpecialEnum;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.common.config.FieldWrapper;

public class CommandRLTweakerConfig
extends CommandBase {
    private final List<String> tabCompletionsCommands = Arrays.asList("rlcraft282", "improvementsonly");

    public String func_71517_b() {
        return "rltweakerconfig";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/rltweakerconfig help";
    }

    public int func_82362_a() {
        return 4;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length == 0) {
            this.help(sender);
            return;
        }
        String firstArgument = args[0].toLowerCase(Locale.ENGLISH);
        if (firstArgument.equals("help")) {
            this.inform("/rltweakerconfig <type>", sender);
            this.inform("Sets RLTweaker config to default values based on the config type given", sender);
            this.inform("Available config types are:\nimprovementsonly\nrlcraft282", sender);
            this.inform("WARNING, this replaces all rltweaker config! Add --confirm to the end of the command to confirm", sender);
            return;
        }
        boolean confirm = false;
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equals("--confirm")) continue;
            confirm = true;
            break;
        }
        if (!confirm) {
            this.inform("WARNING, this replaces all rltweaker config! Add --confirm to the end of the command to confirm", sender);
            return;
        }
        switch (firstArgument) {
            case "rlcraft282": {
                this.updateConfigDefaultsWithAnnotation(RLConfig.RLCraftTwoEightTwo.class, sender);
                break;
            }
            case "improvementsonly": {
                this.updateConfigDefaultsWithAnnotation(RLConfig.ImprovementsOnly.class, sender);
                break;
            }
            default: {
                this.help(sender);
            }
        }
    }

    private void updateConfigDefaultsWithAnnotation(Class<? extends Annotation> annotation, ICommandSender sender) {
        try {
            this.diveInstance(ModConfig.client, annotation);
            this.diveInstance(ModConfig.patches, annotation);
            this.diveInstance(ModConfig.server, annotation);
            ConfigManager.sync((String)"rltweaker", (Config.Type)Config.Type.INSTANCE);
            this.inform("Finished replacing config values, restart the game to complete the configuration", sender);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
            this.inform("Failed to set defaults, there was an error. Check console for details.", sender);
        }
    }

    private void diveInstance(Object instance, Class<? extends Annotation> annotationClazz) throws IllegalArgumentException, IllegalAccessException, NoSuchMethodException, SecurityException, InvocationTargetException {
        if (instance == null) {
            return;
        }
        for (Field f : instance.getClass().getDeclaredFields()) {
            int modifiers;
            if (f.isSynthetic() || !Modifier.isPublic(modifiers = f.getModifiers())) continue;
            boolean hasSpecial = false;
            if (f.isAnnotationPresent(RLConfig.SpecialSignature.class)) {
                hasSpecial = true;
            }
            if (hasSpecial || f.isAnnotationPresent(annotationClazz)) {
                f.setAccessible(true);
                if (hasSpecial) {
                    RLConfig.SpecialSignature signature = (RLConfig.SpecialSignature)RLConfig.SpecialSignature.class.cast(f.getAnnotation(RLConfig.SpecialSignature.class));
                    String annotationValue = this.testSpecial(signature.value(), signature.pass(), signature.fail());
                    if (!this.replaceFieldWithNewValue(instance, f, annotationValue, f.getType().getName())) continue;
                    RLTweaker.logger.debug("Replaced field: " + instance.getClass().getSimpleName() + " : " + f.getName());
                    continue;
                }
                Annotation annotation = annotationClazz.cast(f.getAnnotation(annotationClazz));
                Method m = annotationClazz.getDeclaredMethod("value", new Class[0]);
                if (m == null) {
                    RLTweaker.logger.error("Null method for value in class: " + annotationClazz.getSimpleName() + " : " + instance.getClass().getSimpleName() + " : " + f.getType().getName() + " : " + f.getName());
                    continue;
                }
                String annotationValue = (String)m.invoke((Object)annotation, new Object[0]);
                if (annotationValue == null) {
                    RLTweaker.logger.error("Null string for annotaton value in class: " + annotationClazz.getSimpleName() + " : " + instance.getClass().getSimpleName() + " : " + f.getType().getName() + " : " + f.getName());
                    continue;
                }
                if (!this.replaceFieldWithNewValue(instance, f, annotationValue, f.getType().getName())) continue;
                RLTweaker.logger.debug("Replaced field: " + instance.getClass().getSimpleName() + " : " + f.getName());
                continue;
            }
            if (FieldWrapper.hasWrapperFor((Field)f)) {
                RLTweaker.logger.debug("Unmarked default for: " + annotationClazz.getSimpleName() + " : " + instance.getClass().getSimpleName() + " : " + f.getType().getName() + " : " + f.getName());
                continue;
            }
            if (!f.getType().getName().startsWith("com.charles445.rltweaker.config.")) continue;
            f.setAccessible(true);
            this.diveInstance(f.get(instance), annotationClazz);
        }
    }

    private String testSpecial(SpecialEnum special, String pass, String fail) {
        switch (special) {
            case MAX_ENTITY_RADIUS_HIGH: {
                return World.MAX_ENTITY_RADIUS > 2.0 ? pass : fail;
            }
        }
        RLTweaker.logger.error("testSpecial failed, invalid case");
        return fail;
    }

    private boolean replaceFieldWithNewValue(Object instance, Field f, String annotationValue, String typeString) {
        try {
            switch (typeString) {
                case "boolean": {
                    return this.replaceBoolean(instance, f, annotationValue);
                }
                case "[Z": {
                    return this.unsupported(typeString);
                }
                case "double": {
                    return this.replaceDouble(instance, f, annotationValue);
                }
                case "[D": {
                    return this.unsupported(typeString);
                }
                case "int": {
                    return this.replaceInteger(instance, f, annotationValue);
                }
                case "[I": {
                    return this.replaceIntegerArray(instance, f, annotationValue);
                }
                case "java.lang.String": {
                    return this.replaceString(instance, f, annotationValue);
                }
                case "[Ljava.lang.String;": {
                    return this.replaceStringArray(instance, f, annotationValue);
                }
            }
            return this.unsupported(typeString);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            RLTweaker.logger.error("Error replacing field: " + annotationValue + " " + typeString, (Throwable)e);
            return false;
        }
    }

    private boolean unsupported(String typeString) {
        RLTweaker.logger.error("Unsupported config default type: " + typeString);
        return false;
    }

    private boolean replaceBoolean(Object instance, Field f, String annotationValue) throws IllegalArgumentException, IllegalAccessException {
        switch (annotationValue.trim().toLowerCase(Locale.ENGLISH)) {
            case "false": {
                f.setBoolean(instance, false);
                return true;
            }
            case "true": {
                f.setBoolean(instance, true);
                return true;
            }
        }
        RLTweaker.logger.error("Invalid boolean config default: " + instance.getClass().getSimpleName() + " : " + f.getName() + " : " + annotationValue);
        return false;
    }

    private boolean replaceDouble(Object instance, Field f, String annotationValue) throws IllegalArgumentException, IllegalAccessException {
        try {
            f.setDouble(instance, Double.parseDouble(annotationValue));
            return true;
        }
        catch (NumberFormatException e) {
            RLTweaker.logger.error("Invalid double config default: " + instance.getClass().getSimpleName() + " : " + f.getName() + " : " + annotationValue);
            return false;
        }
    }

    private boolean replaceInteger(Object instance, Field f, String annotationValue) throws IllegalArgumentException, IllegalAccessException {
        try {
            f.setInt(instance, Integer.parseInt(annotationValue));
            return true;
        }
        catch (NumberFormatException e) {
            RLTweaker.logger.error("Invalid int config default: " + instance.getClass().getSimpleName() + " : " + f.getName() + " : " + annotationValue);
            return false;
        }
    }

    private boolean replaceString(Object instance, Field f, String annotationValue) throws IllegalArgumentException, IllegalAccessException {
        f.set(instance, annotationValue);
        return true;
    }

    private boolean replaceIntegerArray(Object instance, Field f, String annotationValue) throws IllegalArgumentException, IllegalAccessException {
        String[] split = annotationValue.split(this.getSplitRegex());
        int[] container = new int[split.length];
        try {
            for (int i = 0; i < split.length; ++i) {
                container[i] = Integer.parseInt(split[i]);
            }
        }
        catch (NumberFormatException e) {
            RLTweaker.logger.error("Invalid int[] config default: " + instance.getClass().getSimpleName() + " : " + f.getName() + " : " + annotationValue);
            return false;
        }
        f.set(instance, container);
        return true;
    }

    private boolean replaceStringArray(Object instance, Field f, String annotationValue) throws IllegalArgumentException, IllegalAccessException {
        String[] split = annotationValue.split(this.getSplitRegex());
        f.set(instance, split);
        return true;
    }

    private String getSplitRegex() {
        return "\\|";
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        if (args.length == 1) {
            return CommandRLTweakerConfig.func_175762_a((String[])args, this.tabCompletionsCommands);
        }
        if (args.length == 0) {
            return this.tabCompletionsCommands;
        }
        return Collections.emptyList();
    }

    private void help(ICommandSender sender) {
        this.inform(this.func_71518_a(sender), sender);
    }

    public void inform(String s, ICommandSender sender) {
        sender.func_145747_a((ITextComponent)new TextComponentString(s));
    }
}

