/*
 * Decompiled with CFR 0.152.
 */
package bedbreakbegone.mixin;

import bedbreakbegone.handlers.ConfigHandler;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EntityPlayer.class})
public abstract class EntityPlayerMixin {
    @Inject(at={@At(value="HEAD")}, method={"getBedSpawnLocation(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Z)Lnet/minecraft/util/math/BlockPos;"}, cancellable=true)
    private static void bbbInject_getBedSpawnLocation(World worldIn, BlockPos bedLocation, boolean forceSpawn, CallbackInfoReturnable<BlockPos> callback) {
        IBlockState state = worldIn.func_180495_p(bedLocation);
        Block block = state.func_177230_c();
        if (!block.isBed(state, (IBlockAccess)worldIn, bedLocation, null)) {
            if (!forceSpawn) {
                if (ConfigHandler.server.spawnWarning) {
                    System.out.println("BBB Non-Forced Spawn failed at: " + bedLocation.func_177958_n() + "X " + bedLocation.func_177956_o() + "Y " + bedLocation.func_177952_p() + "Z");
                }
                callback.setReturnValue(null);
            } else {
                callback.setReturnValue((Object)EntityPlayerMixin.iterateSpawnPoint(worldIn, bedLocation));
            }
        } else {
            callback.setReturnValue((Object)EntityPlayerMixin.iterateBedPoint(worldIn, bedLocation));
        }
    }

    private static BlockPos iterateSpawnPoint(World world, BlockPos pos) {
        if (EntityPlayerMixin.isValidSpawnPos(world, pos, false)) {
            return pos;
        }
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        for (int xIter = x - 1; xIter <= x + 1; ++xIter) {
            for (int zIter = z - 1; zIter <= z + 1; ++zIter) {
                BlockPos blockPos = new BlockPos(xIter, y, zIter);
                if (!EntityPlayerMixin.isValidSpawnPos(world, blockPos, false)) continue;
                return blockPos;
            }
        }
        if (ConfigHandler.server.spawnWarning) {
            System.out.println("BBB Non-Bed Spawnpoint failed at: " + x + "X " + y + "Y " + z + "Z");
        }
        return null;
    }

    private static BlockPos iterateBedPoint(World world, BlockPos pos) {
        EnumFacing enumfacing = (EnumFacing)world.func_180495_p(pos).func_177229_b((IProperty)BlockHorizontal.field_185512_D);
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        for (int yOffset = 0; yOffset <= 1; ++yOffset) {
            for (int facingOffset = 0; facingOffset <= 1; ++facingOffset) {
                int xOffset = x - enumfacing.func_82601_c() * facingOffset;
                int zOffset = z - enumfacing.func_82599_e() * facingOffset;
                for (int xIter = xOffset - 1; xIter <= xOffset + 1; ++xIter) {
                    for (int zIter = zOffset - 1; zIter <= zOffset + 1; ++zIter) {
                        BlockPos blockPos = new BlockPos(xIter, y + yOffset, zIter);
                        if (!EntityPlayerMixin.isValidSpawnPos(world, blockPos, true)) continue;
                        return blockPos;
                    }
                }
            }
        }
        if (ConfigHandler.server.spawnWarning) {
            System.out.println("BBB Bed Spawnpoint failed at: " + x + "X " + y + "Y " + z + "Z");
        }
        return null;
    }

    private static boolean isValidSpawnPos(World worldIn, BlockPos blockPos, boolean requireFloor) {
        return (worldIn.func_180495_p(blockPos.func_177977_b()).func_185904_a().func_76220_a() || !requireFloor) && worldIn.func_180495_p(blockPos).func_177230_c().func_181623_g() && worldIn.func_180495_p(blockPos.func_177984_a()).func_177230_c().func_181623_g();
    }
}

