/*
 * Decompiled with CFR 0.152.
 */
package meldexun.entityculling.util.raytracing;

import java.util.function.IntSupplier;
import meldexun.entityculling.config.EntityCullingConfig;
import meldexun.entityculling.util.MathUtil;
import meldexun.entityculling.util.raytracing.Axis;
import meldexun.entityculling.util.raytracing.IRaytracingCache;
import meldexun.entityculling.util.raytracing.Int2BoolTriFunction;
import meldexun.entityculling.util.raytracing.RaytracingArrayCache;
import meldexun.entityculling.util.raytracing.RaytracingMapCache;

public class RaytracingEngine {
    private double camX;
    private double camY;
    private double camZ;
    private int camBlockX;
    private int camBlockY;
    private int camBlockZ;
    private final IRaytracingCache resultCache = new RaytracingMapCache();
    private final IRaytracingCache opacityCache;
    private final Int2BoolTriFunction isOpaqueFunction;
    private final IntSupplier renderDistSupplier;

    public RaytracingEngine(int cacheSize, Int2BoolTriFunction isOpaqueFunction, IntSupplier renderDistSupplier) {
        this.opacityCache = new RaytracingArrayCache(cacheSize);
        this.isOpaqueFunction = isOpaqueFunction;
        this.renderDistSupplier = renderDistSupplier;
    }

    public void setup(double x, double y, double z) {
        this.camX = x;
        this.camY = y;
        this.camZ = z;
        this.camBlockX = MathUtil.floor(x);
        this.camBlockY = MathUtil.floor(y);
        this.camBlockZ = MathUtil.floor(z);
    }

    public void clearCache() {
        this.resultCache.clearCache();
        this.opacityCache.clearCache();
    }

    public boolean raytraceCachedThreshold(int endX, int endY, int endZ, double threshold) {
        if (this.isTooFarAway(endX, endY, endZ)) {
            return true;
        }
        return this.resultCache.getOrSetCachedValue(endX - this.camBlockX, endY - this.camBlockY, endZ - this.camBlockZ, () -> this.raytraceUncachedThreshold(endX, endY, endZ, threshold));
    }

    public boolean raytraceCached(int endX, int endY, int endZ) {
        if (this.isTooFarAway(endX, endY, endZ)) {
            return true;
        }
        return this.resultCache.getOrSetCachedValue(endX - this.camBlockX, endY - this.camBlockY, endZ - this.camBlockZ, () -> this.raytraceUncached(endX, endY, endZ));
    }

    public boolean raytraceUncachedThreshold(double endX, double endY, double endZ, double threshold) {
        if (this.isTooFarAway(endX, endY, endZ)) {
            return true;
        }
        return this.raytraceThreshold(this.camX, this.camY, this.camZ, endX, endY, endZ, threshold);
    }

    public boolean raytraceUncached(double endX, double endY, double endZ) {
        if (this.isTooFarAway(endX, endY, endZ)) {
            return true;
        }
        return this.raytrace(this.camX, this.camY, this.camZ, endX, endY, endZ);
    }

    private boolean isTooFarAway(double x, double y, double z) {
        double maxDistSqr;
        double distSqr = EntityCullingConfig.raytraceDistanceCalculator.distSqr(this.camX, this.camY, this.camZ, x, y, z);
        return distSqr > (maxDistSqr = MathUtil.square(((double)(this.renderDistSupplier.getAsInt() << 4) + EntityCullingConfig.raytraceDistanceLimitAdder) * EntityCullingConfig.raytraceDistanceLimitMultiplier));
    }

    private boolean raytraceThreshold(double startX, double startY, double startZ, double endX, double endY, double endZ, double threshold) {
        double nextHitZ;
        double nextHitY;
        double d1;
        double nextHitX;
        if (threshold <= 0.0) {
            return this.raytrace(startX, startY, startZ, endX, endY, endZ);
        }
        double dirX = endX - startX;
        double dirY = endY - startY;
        double dirZ = endZ - startZ;
        if (dirX * dirX + dirY * dirY + dirZ * dirZ <= threshold * threshold) {
            return true;
        }
        int x = MathUtil.floor(startX);
        int y = MathUtil.floor(startY);
        int z = MathUtil.floor(startZ);
        int incX = MathUtil.signum(dirX);
        int incY = MathUtil.signum(dirY);
        int incZ = MathUtil.signum(dirZ);
        double dx = incX == 0 ? Double.MAX_VALUE : (double)incX / dirX;
        double dy = incY == 0 ? Double.MAX_VALUE : (double)incY / dirY;
        double dz = incZ == 0 ? Double.MAX_VALUE : (double)incZ / dirZ;
        double percentX = dx * (incX > 0 ? 1.0 - MathUtil.frac(startX) : MathUtil.frac(startX));
        double percentY = dy * (incY > 0 ? 1.0 - MathUtil.frac(startY) : MathUtil.frac(startY));
        double percentZ = dz * (incZ > 0 ? 1.0 - MathUtil.frac(startZ) : MathUtil.frac(startZ));
        if (this.isOpaque(x, y, z) && (threshold -= MathUtil.dist(startX, startY, startZ, nextHitX = startX + dirX * (d1 = Math.min(Math.min(Math.min(percentX, percentY), percentZ), 1.0)), nextHitY = startY + dirY * d1, nextHitZ = startZ + dirZ * d1)) <= 0.0) {
            return false;
        }
        while (percentX <= 1.0 || percentY <= 1.0 || percentZ <= 1.0) {
            double nextHitZ2;
            double nextHitY2;
            double d12;
            double nextHitX2;
            double hitZ;
            double hitY;
            Axis axis;
            if (percentX < percentY) {
                if (percentX < percentZ) {
                    x += incX;
                    percentX += dx;
                    axis = Axis.X;
                } else {
                    z += incZ;
                    percentZ += dz;
                    axis = Axis.Z;
                }
            } else if (percentY < percentZ) {
                y += incY;
                percentY += dy;
                axis = Axis.Y;
            } else {
                z += incZ;
                percentZ += dz;
                axis = Axis.Z;
            }
            if (!this.isOpaque(x, y, z)) continue;
            double d = axis != Axis.X ? (axis != Axis.Y ? percentZ - dz : percentY - dy) : percentX - dx;
            double d2 = Math.min(d, 1.0);
            double hitX = startX + dirX * d2;
            if (!((threshold -= MathUtil.dist(hitX, hitY = startY + dirY * d2, hitZ = startZ + dirZ * d2, nextHitX2 = startX + dirX * (d12 = Math.min(Math.min(Math.min(percentX, percentY), percentZ), 1.0)), nextHitY2 = startY + dirY * d12, nextHitZ2 = startZ + dirZ * d12)) <= 0.0)) continue;
            return false;
        }
        return true;
    }

    private boolean raytrace(double startX, double startY, double startZ, double endX, double endY, double endZ) {
        int z;
        int y;
        int x = MathUtil.floor(startX);
        if (this.isOpaque(x, y = MathUtil.floor(startY), z = MathUtil.floor(startZ))) {
            return false;
        }
        double dirX = endX - startX;
        double dirY = endY - startY;
        double dirZ = endZ - startZ;
        int incX = MathUtil.signum(dirX);
        int incY = MathUtil.signum(dirY);
        int incZ = MathUtil.signum(dirZ);
        double dx = incX == 0 ? Double.MAX_VALUE : (double)incX / dirX;
        double dy = incY == 0 ? Double.MAX_VALUE : (double)incY / dirY;
        double dz = incZ == 0 ? Double.MAX_VALUE : (double)incZ / dirZ;
        double percentX = dx * (incX > 0 ? 1.0 - MathUtil.frac(startX) : MathUtil.frac(startX));
        double percentY = dy * (incY > 0 ? 1.0 - MathUtil.frac(startY) : MathUtil.frac(startY));
        double percentZ = dz * (incZ > 0 ? 1.0 - MathUtil.frac(startZ) : MathUtil.frac(startZ));
        while (percentX <= 1.0 || percentY <= 1.0 || percentZ <= 1.0) {
            if (percentX < percentY) {
                if (percentX < percentZ) {
                    x += incX;
                    percentX += dx;
                } else {
                    z += incZ;
                    percentZ += dz;
                }
            } else if (percentY < percentZ) {
                y += incY;
                percentY += dy;
            } else {
                z += incZ;
                percentZ += dz;
            }
            if (!this.isOpaque(x, y, z)) continue;
            return false;
        }
        return true;
    }

    private boolean isOpaque(int x, int y, int z) {
        return this.opacityCache.getOrSetCachedValue(x - this.camBlockX, y - this.camBlockY, z - this.camBlockZ, () -> this.isOpaqueFunction.applyAsBool(x, y, z));
    }
}

