/*
 * Decompiled with CFR 0.152.
 */
package meldexun.entityculling.util;

import java.nio.ByteBuffer;
import java.util.function.Supplier;
import meldexun.entityculling.util.ResourceSupplier;
import meldexun.entityculling.util.culling.GLHelper;
import meldexun.matrixutil.Matrix4f;
import meldexun.renderlib.api.IBoundingBoxCache;
import meldexun.renderlib.util.BufferUtil;
import meldexun.renderlib.util.GLShader;
import meldexun.renderlib.util.GLUtil;
import meldexun.renderlib.util.MutableAABB;
import meldexun.renderlib.util.RenderUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;

public class BoundingBoxHelper {
    private static final String A_POS = "a_Pos";
    private static final String U_MATRIX = "u_ModelViewProjectionMatrix";
    private static BoundingBoxHelper instance;
    private final GLShader shader = new GLShader.Builder().addShader(35633, (Supplier)new ResourceSupplier(new ResourceLocation("entityculling", "shaders/debug.vsh"))).addShader(35632, (Supplier)new ResourceSupplier(new ResourceLocation("entityculling", "shaders/debug.fsh"))).bindAttribute("a_Pos", 0).build();
    private final int cubeVertexBuffer = GL15.glGenBuffers();
    private final int triangleStripCubeIndexBuffer;
    private final int linesCubeIndexBuffer;
    private final int quadsCubeIndexBuffer;

    public BoundingBoxHelper() {
        GL15.glBindBuffer((int)34962, (int)this.cubeVertexBuffer);
        GL15.glBufferData((int)34962, (ByteBuffer)BufferUtil.buffer((byte[])new byte[]{0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 1, 1, 1, 0, 0, 1, 0, 1, 1, 1, 0, 1, 1, 1}), (int)35044);
        GL15.glBindBuffer((int)34962, (int)0);
        this.triangleStripCubeIndexBuffer = GL15.glGenBuffers();
        GL15.glBindBuffer((int)34963, (int)this.triangleStripCubeIndexBuffer);
        GL15.glBufferData((int)34963, (ByteBuffer)BufferUtil.buffer((byte[])new byte[]{7, 3, 5, 1, 0, 3, 2, 7, 6, 5, 4, 0, 6, 2}), (int)35044);
        GL15.glBindBuffer((int)34963, (int)0);
        this.linesCubeIndexBuffer = GL15.glGenBuffers();
        GL15.glBindBuffer((int)34963, (int)this.linesCubeIndexBuffer);
        GL15.glBufferData((int)34963, (ByteBuffer)BufferUtil.buffer((byte[])new byte[]{0, 1, 1, 5, 5, 4, 4, 0, 0, 2, 1, 3, 5, 7, 4, 6, 2, 3, 3, 7, 7, 6, 6, 2}), (int)35044);
        GL15.glBindBuffer((int)34963, (int)0);
        this.quadsCubeIndexBuffer = GL15.glGenBuffers();
        GL15.glBindBuffer((int)34963, (int)this.quadsCubeIndexBuffer);
        GL15.glBufferData((int)34963, (ByteBuffer)BufferUtil.buffer((byte[])new byte[]{0, 4, 5, 1, 3, 7, 6, 2, 4, 0, 2, 6, 1, 5, 7, 3, 0, 1, 3, 2, 5, 4, 6, 7}), (int)35044);
        GL15.glBindBuffer((int)34963, (int)0);
    }

    public static BoundingBoxHelper getInstance() {
        if (instance == null) {
            instance = new BoundingBoxHelper();
        }
        return instance;
    }

    public void drawRenderBoxes(double partialTicks) {
        Matrix4f matrix;
        MutableAABB aabb;
        this.setupRenderState();
        GLShader.push();
        this.shader.use();
        GL15.glBindBuffer((int)34963, (int)this.quadsCubeIndexBuffer);
        GL15.glBindBuffer((int)34962, (int)this.cubeVertexBuffer);
        GL20.glVertexAttribPointer((int)this.shader.getAttribute(A_POS), (int)3, (int)5120, (boolean)false, (int)0, (long)0L);
        GL20.glEnableVertexAttribArray((int)this.shader.getAttribute(A_POS));
        Minecraft mc = Minecraft.func_71410_x();
        for (Entity e : mc.field_71441_e.field_72996_f) {
            if (e == mc.func_175606_aa() || !(aabb = ((IBoundingBoxCache)e).getCachedBoundingBox()).isVisible(RenderUtil.getFrustum())) continue;
            matrix = RenderUtil.getProjectionModelViewMatrix().copy();
            matrix.translate((float)(aabb.minX() - RenderUtil.getCameraEntityX()), (float)(aabb.minY() - RenderUtil.getCameraEntityY()), (float)(aabb.minZ() - RenderUtil.getCameraEntityZ()));
            matrix.scale((float)aabb.sizeX(), (float)aabb.sizeY(), (float)aabb.sizeZ());
            GLUtil.setMatrix((int)this.shader.getUniform(U_MATRIX), (Matrix4f)matrix);
            GL11.glDrawElements((int)7, (int)24, (int)5121, (long)0L);
            GL11.glPolygonMode((int)1032, (int)6913);
            GL11.glDrawElements((int)7, (int)24, (int)5121, (long)0L);
            GL11.glPolygonMode((int)1032, (int)6914);
        }
        for (TileEntity te : mc.field_71441_e.field_147482_g) {
            aabb = ((IBoundingBoxCache)te).getCachedBoundingBox();
            if (!aabb.isVisible(RenderUtil.getFrustum())) continue;
            matrix = RenderUtil.getProjectionModelViewMatrix().copy();
            matrix.translate((float)(aabb.minX() - RenderUtil.getCameraEntityX()), (float)(aabb.minY() - RenderUtil.getCameraEntityY()), (float)(aabb.minZ() - RenderUtil.getCameraEntityZ()));
            matrix.scale((float)aabb.sizeX(), (float)aabb.sizeY(), (float)aabb.sizeZ());
            GLUtil.setMatrix((int)this.shader.getUniform(U_MATRIX), (Matrix4f)matrix);
            GL11.glDrawElements((int)7, (int)24, (int)5121, (long)0L);
            GL11.glPolygonMode((int)1032, (int)6913);
            GL11.glDrawElements((int)7, (int)24, (int)5121, (long)0L);
            GL11.glPolygonMode((int)1032, (int)6914);
        }
        GL20.glDisableVertexAttribArray((int)this.shader.getAttribute(A_POS));
        GL15.glBindBuffer((int)34962, (int)0);
        GL15.glBindBuffer((int)34963, (int)0);
        GLShader.pop();
        this.clearRenderState();
    }

    private void setupRenderState() {
        GLHelper.saveShaderGLState();
        GlStateManager.func_179147_l();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179126_j();
        GlStateManager.func_179143_c((int)515);
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179129_p();
        GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
    }

    private void clearRenderState() {
        GLHelper.restoreShaderGLState();
    }
}

