/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.util.handlers.mana;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapStorage;
import net.minecraft.world.storage.WorldSavedData;
import xzeroair.trinkets.util.handlers.mana.ManaSphere;

public class WorldMana
extends WorldSavedData {
    private static String NAME = "ManaData";
    private final Map<ChunkPos, ManaSphere> spheres = new HashMap<ChunkPos, ManaSphere>();
    private int ticker = 10;

    public WorldMana() {
        super(NAME);
    }

    public static WorldMana get(World world) {
        MapStorage storage = world.getPerWorldStorage();
        WorldMana instance = (WorldMana)storage.func_75742_a(WorldMana.class, NAME);
        if (instance == null) {
            instance = new WorldMana();
            storage.func_75745_a(NAME, (WorldSavedData)instance);
        }
        return instance;
    }

    public float getManaInfluence(World world, BlockPos pos) {
        ChunkPos chunkPos = new ChunkPos(pos);
        float mana = 0.0f;
        for (int dx = -4; dx <= 4; ++dx) {
            for (int dz = -4; dz <= 4; ++dz) {
                double distanceSq;
                ChunkPos cp = new ChunkPos(chunkPos.field_77276_a + dx, chunkPos.field_77275_b + dz);
                ManaSphere sphere = this.getOrCreateSphereAt(world, cp);
                if (!(sphere.getRadius() > 0.0f) || !((distanceSq = pos.func_177951_i((Vec3i)sphere.getCenter())) < (double)(sphere.getRadius() * sphere.getRadius()))) continue;
                double distance = Math.sqrt(distanceSq);
                mana = (float)((double)mana + ((double)sphere.getRadius() - distance) / (double)sphere.getRadius());
            }
        }
        return mana;
    }

    public float getManaStrength(World world, BlockPos pos) {
        ChunkPos chunkPos = new ChunkPos(pos);
        float mana = 0.0f;
        for (int dx = -4; dx <= 4; ++dx) {
            for (int dz = -4; dz <= 4; ++dz) {
                double distanceSq;
                ChunkPos cp = new ChunkPos(chunkPos.field_77276_a + dx, chunkPos.field_77275_b + dz);
                ManaSphere sphere = this.getOrCreateSphereAt(world, cp);
                if (!(sphere.getRadius() > 0.0f) || !((distanceSq = pos.func_177951_i((Vec3i)sphere.getCenter())) < (double)(sphere.getRadius() * sphere.getRadius()))) continue;
                double distance = Math.sqrt(distanceSq);
                double influence = ((double)sphere.getRadius() - distance) / (double)sphere.getRadius();
                mana = (float)((double)mana + influence * (double)sphere.getCurrentMana());
            }
        }
        return mana;
    }

    public float extractMana(World world, BlockPos pos) {
        float manaInfluence = this.getManaInfluence(world, pos);
        if (manaInfluence <= 0.0f) {
            return 0.0f;
        }
        ChunkPos chunkPos = new ChunkPos(pos);
        float extracted = 0.0f;
        for (int dx = -4; dx <= 4; ++dx) {
            for (int dz = -4; dz <= 4; ++dz) {
                float currentMana;
                double distanceSq;
                ChunkPos cp = new ChunkPos(chunkPos.field_77276_a + dx, chunkPos.field_77275_b + dz);
                ManaSphere sphere = this.getOrCreateSphereAt(world, cp);
                if (!(sphere.getRadius() > 0.0f) || !((distanceSq = pos.func_177951_i((Vec3i)sphere.getCenter())) < (double)(sphere.getRadius() * sphere.getRadius()))) continue;
                double distance = Math.sqrt(distanceSq);
                double influence = ((double)sphere.getRadius() - distance) / (double)sphere.getRadius();
                if (influence > (double)(currentMana = sphere.getCurrentMana())) {
                    influence = currentMana;
                }
                currentMana = (float)((double)currentMana - influence);
                extracted = (float)((double)extracted + influence);
                sphere.setCurrentMana(currentMana);
                this.func_76185_a();
            }
        }
        return extracted;
    }

    public void tick(World world) {
        --this.ticker;
        if (this.ticker > 0) {
            return;
        }
        this.ticker = 10;
        this.growMana(world);
        this.sendMana(world);
    }

    private void growMana(World world) {
        for (Map.Entry<ChunkPos, ManaSphere> entry : this.spheres.entrySet()) {
            ManaSphere sphere = entry.getValue();
            if (!(sphere.getRadius() > 0.0f) || !world.func_175667_e(sphere.getCenter())) continue;
            float currentMana = sphere.getCurrentMana();
            if ((currentMana += 0.01f) >= 5.0f) {
                currentMana = 5.0f;
            }
            sphere.setCurrentMana(currentMana);
            this.func_76185_a();
        }
    }

    private void sendMana(World world) {
        for (EntityPlayer player : world.field_73010_i) {
            float manaStrength = this.getManaStrength(world, player.func_180425_c());
            float f = this.getManaInfluence(world, player.func_180425_c());
        }
    }

    private ManaSphere getOrCreateSphereAt(World world, ChunkPos cp) {
        ManaSphere sphere = this.spheres.get(cp);
        if (sphere == null) {
            BlockPos center = cp.func_180331_a(8, ManaSphere.getRandomYOffset(world.func_72905_C(), cp.field_77276_a, cp.field_77275_b), 8);
            float radius = 0.0f;
            if (ManaSphere.isCenterChunk(world.func_72905_C(), cp.field_77276_a, cp.field_77275_b)) {
                radius = ManaSphere.getRadius(world.func_72905_C(), cp.field_77276_a, cp.field_77275_b);
            }
            sphere = new ManaSphere(center, radius);
            this.spheres.put(cp, sphere);
            this.func_76185_a();
        }
        return sphere;
    }

    public void func_76184_a(NBTTagCompound nbt) {
        NBTTagList list = nbt.func_150295_c("spheres", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound sphereNBT = list.func_150305_b(i);
            ChunkPos pos = new ChunkPos(sphereNBT.func_74762_e("cx"), sphereNBT.func_74762_e("cz"));
            ManaSphere sphere = new ManaSphere(new BlockPos(sphereNBT.func_74762_e("posx"), sphereNBT.func_74762_e("posy"), sphereNBT.func_74762_e("posz")), sphereNBT.func_74760_g("radius"));
            sphere.setCurrentMana(sphereNBT.func_74760_g("mana"));
            this.spheres.put(pos, sphere);
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound compound) {
        NBTTagList list = new NBTTagList();
        for (Map.Entry<ChunkPos, ManaSphere> entry : this.spheres.entrySet()) {
            NBTTagCompound sphereNBT = new NBTTagCompound();
            ChunkPos pos = entry.getKey();
            ManaSphere sphere = entry.getValue();
            sphereNBT.func_74768_a("cx", pos.field_77276_a);
            sphereNBT.func_74768_a("cz", pos.field_77275_b);
            sphereNBT.func_74768_a("posx", sphere.getCenter().func_177958_n());
            sphereNBT.func_74768_a("posy", sphere.getCenter().func_177956_o());
            sphereNBT.func_74768_a("posz", sphere.getCenter().func_177952_p());
            sphereNBT.func_74776_a("radius", sphere.getRadius());
            sphereNBT.func_74776_a("mana", sphere.getCurrentMana());
            list.func_74742_a((NBTBase)sphereNBT);
        }
        compound.func_74782_a("spheres", (NBTBase)list);
        return compound;
    }
}

