/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.traits.abilities.other;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import xzeroair.trinkets.races.titan.config.TitanConfig;
import xzeroair.trinkets.traits.abilities.Ability;
import xzeroair.trinkets.traits.abilities.interfaces.IAttackAbility;
import xzeroair.trinkets.traits.abilities.interfaces.IMiningAbility;
import xzeroair.trinkets.util.TrinketsConfig;
import xzeroair.trinkets.util.config.ConfigHelper;
import xzeroair.trinkets.util.helpers.BlockHelperUtil;

public class AbilityLargeHands
extends Ability
implements IAttackAbility,
IMiningAbility {
    public static final TitanConfig serverConfig = TrinketsConfig.SERVER.races.titan;

    public AbilityLargeHands() {
        super("large_hands");
    }

    @Override
    public float hurtEntity(EntityLivingBase target, DamageSource source, float dmg) {
        if (this.isIndirectDamage(source)) {
            return dmg;
        }
        Entity attacker = source.func_76346_g();
        AxisAlignedBB bb = target.func_174813_aQ().func_186662_g(1.0);
        Predicate Targets = Predicates.and((Predicate)EntitySelectors.field_180132_d, ent -> ent != null && ent.func_70067_L() && ent != attacker && ent != target && ent.func_145782_y() != target.func_145782_y());
        List splash = target.func_130014_f_().func_175647_a(Entity.class, bb, Targets);
        Object sSource = DamageSource.field_76377_j;
        if (attacker instanceof EntityLivingBase) {
            sSource = attacker instanceof EntityPlayer ? new EntityDamageSourceIndirect("player", attacker, attacker) : DamageSource.func_188403_a((Entity)attacker, (EntityLivingBase)((EntityLivingBase)attacker));
        }
        for (Entity hit : splash) {
            hit.func_70097_a(sSource, dmg * 0.25f);
        }
        return dmg;
    }

    @Override
    public float breakingBlock(EntityLivingBase entity, IBlockState state, BlockPos pos, float originalSpeed, float newSpeed) {
        ItemStack heldItemStack;
        World world = entity.func_130014_f_();
        ItemStack itemStack = heldItemStack = entity instanceof EntityPlayer ? ((EntityPlayer)entity).field_71071_by.func_70448_g() : entity.func_184607_cu();
        if (heldItemStack.func_190926_b()) {
            Block block = state.func_177230_c();
            String neededTool = block.getHarvestTool(state);
            ItemStack toolUsed = this.getHarvestTool(neededTool, heldItemStack);
            float newDigSpeed = BlockHelperUtil.getEntityDigSpeed(entity, toolUsed, state, pos, false);
            float hardness = state.func_185887_b(world, pos);
            if (hardness > 0.0f && entity instanceof EntityPlayer && !ForgeHooks.canHarvestBlock((Block)block, (EntityPlayer)((EntityPlayer)entity), (IBlockAccess)world, (BlockPos)pos)) {
                return newDigSpeed * 2.0f;
            }
            return newDigSpeed;
        }
        return newSpeed;
    }

    @Override
    public int brokeBlock(EntityLivingBase entity, World world, IBlockState state, BlockPos pos, int expToDrop) {
        boolean flag;
        boolean bl = AbilityLargeHands.serverConfig.miningExtendInverted ? !entity.func_70093_af() : (flag = entity.func_70093_af());
        if (!AbilityLargeHands.serverConfig.miningExtend || flag || expToDrop < 0) {
            return expToDrop;
        }
        for (String s : AbilityLargeHands.serverConfig.miningAoEBlacklist) {
            ConfigHelper.ConfigObject object = new ConfigHelper.ConfigObject(s);
            if (!object.doesBlockMatchEntry(state)) continue;
            return expToDrop;
        }
        ItemStack heldItemStack = entity instanceof EntityPlayer ? ((EntityPlayer)entity).field_71071_by.func_70448_g() : entity.func_184607_cu();
        Block block = state.func_177230_c();
        String neededTool = block.getHarvestTool(state);
        ItemStack toolUsed = this.getHarvestTool(neededTool, heldItemStack);
        if (BlockHelperUtil.canToolHarvestBlock(toolUsed, state) && BlockHelperUtil.isToolEffective(toolUsed, state)) {
            ImmutableList<BlockPos> list = BlockHelperUtil.getBlockList(toolUsed, world, (EntityPlayer)entity, pos, 3, 3, 3, checkPos -> {
                boolean skip = false;
                for (String s : AbilityLargeHands.serverConfig.miningAoEBlacklist) {
                    ConfigHelper.ConfigObject object = new ConfigHelper.ConfigObject(s);
                    if (!object.doesBlockMatchEntry(world.func_180495_p(pos))) continue;
                    skip = true;
                }
                return !skip;
            });
            for (BlockPos ePos : list) {
                BlockHelperUtil.breakBlock((EntityPlayer)entity, toolUsed, world, state, pos, ePos, true);
            }
            BlockHelperUtil.breakBlock((EntityPlayer)entity, toolUsed, world, state, pos, pos, false);
            return 0;
        }
        return expToDrop;
    }

    public ItemStack getHarvestTool(String needed, ItemStack heldTool) {
        if (needed == null) {
            return heldTool.func_77946_l();
        }
        if (heldTool.func_190926_b()) {
            switch (needed) {
                case "pickaxe": {
                    return new ItemStack(Items.field_151039_o);
                }
                case "shovel": {
                    return new ItemStack(Items.field_151038_n);
                }
                case "axe": {
                    return new ItemStack(Items.field_151053_p);
                }
            }
            return heldTool.func_77946_l();
        }
        return heldTool.func_77946_l();
    }
}

