/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.traits.abilities;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import xzeroair.trinkets.Trinkets;
import xzeroair.trinkets.traits.abilities.Ability;
import xzeroair.trinkets.traits.abilities.interfaces.IMiningAbility;
import xzeroair.trinkets.traits.abilities.interfaces.ITickableAbility;
import xzeroair.trinkets.util.TrinketsConfig;
import xzeroair.trinkets.util.config.ClientConfig;
import xzeroair.trinkets.util.config.trinkets.ConfigSeaStone;

public class AbilityWaterAffinity
extends Ability
implements ITickableAbility,
IMiningAbility {
    public static final ConfigSeaStone serverConfig = TrinketsConfig.SERVER.Items.SEA_STONE;
    public static final ClientConfig.ClientConfigItems.ClientConfigSeaStone clientConfig = TrinketsConfig.CLIENT.items.SEA_STONE;

    public AbilityWaterAffinity() {
        super("water_affinity");
    }

    @Override
    public void tickAbility(EntityLivingBase entity) {
        if (AbilityWaterAffinity.serverConfig.underwater_breathing) {
            if (!AbilityWaterAffinity.serverConfig.always_full) {
                if (entity.func_70086_ai() < 20) {
                    entity.func_70050_g(20);
                }
            } else {
                entity.func_70050_g(300);
            }
            if (Trinkets.BetterDiving) {
                entity.func_70690_d(new PotionEffect(MobEffects.field_76427_o, 150, 0, false, false));
            }
        }
        if (!Trinkets.BetterDiving && AbilityWaterAffinity.serverConfig.Swim_Tweaks && !this.isSpectator((Entity)entity) && !this.isCreativeFlying((Entity)entity)) {
            BlockPos head = entity.func_180425_c();
            IBlockState headBlock = entity.field_70170_p.func_180495_p(head);
            Block block = headBlock.func_177230_c();
            if ((entity.func_70090_H() || entity.func_180799_ab()) && block != Blocks.field_150350_a) {
                if (AbilityWaterAffinity.serverConfig.old_tweaks) {
                    this.handleMovementOld(entity);
                } else {
                    this.handleMovement(entity);
                }
            }
        }
    }

    @Override
    public float breakingBlock(EntityLivingBase entity, IBlockState state, BlockPos pos, float originalSpeed, float newSpeed) {
        if (TrinketsConfig.SERVER.Items.SEA_STONE.Swim_Tweaks && entity.func_70055_a(Material.field_151586_h) && !EnchantmentHelper.func_185287_i((EntityLivingBase)entity)) {
            float speed = originalSpeed;
            speed *= 5.0f;
            if (!entity.field_70122_E) {
                speed *= 5.0f;
            }
            if (newSpeed < speed) {
                return speed;
            }
        }
        return newSpeed;
    }

    protected void handleMovementOld(EntityLivingBase entity) {
        double motion = 0.1;
        double bouyance = 0.25;
        if (entity.func_180799_ab()) {
            motion = 0.09;
        }
        if (!entity.func_70093_af()) {
            entity.field_70181_x = 0.0;
            if (this.movingForward(entity, entity.func_174811_aO()) && (entity.field_70159_w > motion || entity.field_70159_w < -motion || entity.field_70179_y > motion || entity.field_70179_y < -motion)) {
                entity.field_70181_x += MathHelper.func_151237_a((double)(entity.func_70040_Z().field_72448_b / 1.0), (double)-0.25, (double)0.25);
            }
        } else if (!this.movingForward(entity, entity.func_174811_aO()) && !(entity.field_70181_x > 0.0)) {
            entity.field_70181_x = entity.func_180799_ab() ? (entity.field_70181_x *= 1.75) : (entity.field_70181_x *= 1.25);
        }
    }

    protected double getSwimSpeedFromPlayer(EntityLivingBase entity) {
        IAttributeInstance movement = entity.func_110148_a(SharedMonsterAttributes.field_111263_d);
        IAttributeInstance swimMovement = entity.func_110148_a(EntityLivingBase.SWIM_SPEED);
        double swimMulti = swimMovement != null ? swimMovement.func_111126_e() * 0.2 : 1.0;
        double movementSpeed = movement != null ? movement.func_111125_b() : 0.1;
        double swimSpeedBase = movementSpeed * Math.max(swimMulti, 0.0);
        ItemStack feet = entity.func_184582_a(EntityEquipmentSlot.FEET);
        double min = swimSpeedBase * 0.01;
        double max = swimSpeedBase * 1.0;
        double speed = MathHelper.func_151237_a((double)swimSpeedBase, (double)min, (double)max);
        double depthStriderLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185300_i, (ItemStack)feet);
        if (depthStriderLevel > 0.0) {
            speed += swimSpeedBase * 0.667 * depthStriderLevel;
        }
        return speed;
    }

    protected double calculateSlow(EntityLivingBase entity) {
        IAttributeInstance movement = entity.func_110148_a(SharedMonsterAttributes.field_111263_d);
        IAttributeInstance swimMovement = entity.func_110148_a(EntityLivingBase.SWIM_SPEED);
        double swimMulti = swimMovement != null ? swimMovement.func_111126_e() : 1.0;
        double movementSpeed = movement != null ? movement.func_111125_b() : 0.1;
        double swimSpeedBase = movementSpeed * Math.max(swimMulti, 0.0);
        double slow = swimSpeedBase * 0.2;
        ItemStack feet = entity.func_184582_a(EntityEquipmentSlot.FEET);
        double depthStrider = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185300_i, (ItemStack)feet);
        if (depthStrider > 0.0) {
            if (depthStrider > 3.0) {
                depthStrider = 3.0;
            }
            if (!entity.field_70122_E) {
                depthStrider *= 0.5;
            } else if (entity.func_184585_cz()) {
                depthStrider *= 0.02;
            }
            double striderSlow = (swimSpeedBase - slow) * depthStrider / 3.0;
            slow += striderSlow;
        }
        return slow;
    }

    protected void handleMovement(EntityLivingBase entity) {
        if (!entity.field_70170_p.field_72995_K) {
            entity.field_70181_x += 0.02;
        } else {
            GameSettings settings = Minecraft.func_71410_x().field_71474_y;
            boolean inputForward = settings.field_74351_w.func_151470_d();
            boolean inputBack = settings.field_74368_y.func_151470_d();
            boolean inputRight = settings.field_74366_z.func_151470_d();
            boolean inputLeft = settings.field_74370_x.func_151470_d();
            boolean inputUp = settings.field_74314_A.func_151470_d();
            boolean inputDown = settings.field_74311_E.func_151470_d();
            float rotationPitch = entity.field_70125_A;
            float rotationYaw = entity.field_70177_z;
            double slow = this.calculateSlow(entity);
            double speed = this.getSwimSpeedFromPlayer(entity);
            double strafe = 0.0;
            double forward = 0.0;
            double up = 0.0;
            if (inputForward) {
                forward += 1.0;
            }
            if (inputBack) {
                forward -= 1.0;
            }
            if (inputRight) {
                strafe -= 1.0;
            }
            if (inputLeft) {
                strafe += 1.0;
            }
            if (inputUp) {
                up += 1.0;
            }
            if (inputDown) {
                up -= 1.0;
            }
            if (inputDown) {
                slow *= 0.3;
            }
            entity.field_70181_x += 0.02;
            if (inputForward != inputBack || inputRight != inputLeft) {
                this.move2D((Entity)entity, strafe, forward, -slow, rotationYaw);
            }
            if (inputForward != inputBack || inputRight != inputLeft || inputUp != inputDown) {
                if (inputForward && !inputBack) {
                    if (inputUp && !inputDown) {
                        rotationPitch = (rotationPitch - 90.0f) / 2.0f;
                        up = 0.0;
                    } else if (inputDown && !inputUp) {
                        rotationPitch = (rotationPitch + 90.0f) / 2.0f;
                        up = 0.0;
                    }
                } else if (inputBack && !inputForward) {
                    if (inputUp && !inputDown) {
                        rotationPitch = (rotationPitch + 90.0f) / 2.0f;
                        up = 0.0;
                    } else if (inputDown && !inputUp) {
                        rotationPitch = (rotationPitch - 90.0f) / 2.0f;
                        up = 0.0;
                    }
                }
                this.move3D(entity, strafe, up, forward, speed, rotationYaw, rotationPitch);
                ItemStack feet = entity.func_184582_a(EntityEquipmentSlot.FEET);
                int depthStriderLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185300_i, (ItemStack)feet);
                if (inputUp) {
                    entity.field_70181_x = depthStriderLevel == 0 ? (entity.field_70181_x *= 0.6) : (entity.field_70181_x *= 0.772);
                }
                if (inputDown && depthStriderLevel != 0) {
                    entity.field_70181_x *= 0.936;
                }
            }
        }
    }

    protected void move2D(Entity entity, double strafe, double forward, double speed, double yaw) {
        double d = strafe * strafe + forward * forward;
        if (d >= 1.0E-4) {
            if ((d = Math.sqrt(d)) < 1.0) {
                d = 1.0;
            }
            d = speed / d;
            double d1 = Math.sin(yaw * 0.017453292);
            double d2 = Math.cos(yaw * 0.017453292);
            entity.field_70159_w += (strafe *= d) * d2 - (forward *= d) * d1;
            entity.field_70179_y += forward * d2 + strafe * d1;
        }
    }

    protected void move3D(EntityLivingBase entity, double strafe, double up, double forward, double speed, double yaw, double pitch) {
        double d = strafe * strafe + up * up + forward * forward;
        if (d >= 1.0E-4) {
            if ((d = Math.sqrt(d)) < 1.0) {
                d = 1.0;
            }
            d = speed / d;
            strafe *= d;
            double d1 = Math.sin(yaw * 0.017453292);
            double d2 = Math.cos(yaw * 0.017453292);
            double d3 = Math.sin(pitch * 0.017453292);
            double d4 = Math.cos(pitch * 0.017453292);
            double upMotion = (up *= d) - (forward *= d) * d3;
            entity.field_70159_w += strafe * d2 - forward * d1 * d4;
            entity.field_70181_x += upMotion;
            entity.field_70179_y += forward * d2 * d4 + strafe * d1;
        }
    }

    protected boolean movingForward(EntityLivingBase entity, EnumFacing facing) {
        return (double)entity.func_174811_aO().func_176730_m().func_177958_n() * entity.field_70159_w > 0.0 || (double)entity.func_174811_aO().func_176730_m().func_177952_p() * entity.field_70179_y > 0.0;
    }
}

