/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.races.fairy;

import java.util.Arrays;
import java.util.List;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import xzeroair.trinkets.client.model.Wings;
import xzeroair.trinkets.init.EntityRaces;
import xzeroair.trinkets.races.EntityRacePropertiesHandler;
import xzeroair.trinkets.races.fairy.config.FairyConfig;
import xzeroair.trinkets.traits.abilities.AbilityClimbing;
import xzeroair.trinkets.traits.abilities.AbilityFlying;
import xzeroair.trinkets.util.TrinketsConfig;
import xzeroair.trinkets.util.config.ClientConfig;
import xzeroair.trinkets.util.helpers.ColorHelper;
import xzeroair.trinkets.util.helpers.DrawingHelper;

public class RaceFairy
extends EntityRacePropertiesHandler {
    public static final FairyConfig serverConfig = TrinketsConfig.SERVER.races.fairy;
    public static final ClientConfig.ClientConfigItems.ClientConfigFairyRing clientConfig = TrinketsConfig.CLIENT.items.FAIRY_RING;
    public static List<String> disallowedMounts = Arrays.asList(RaceFairy.serverConfig.mountBlacklist);
    public static final ResourceLocation TEXTURE = new ResourceLocation("xat:textures/fairy_wings.png");
    int tick = 0;
    float armSwing = 0.0f;
    private final ModelBase wings = new Wings();

    public RaceFairy(EntityLivingBase e) {
        super(e, EntityRaces.fairy);
        disallowedMounts = Arrays.asList(RaceFairy.serverConfig.mountBlacklist);
    }

    @Override
    public void startTransformation() {
        if (RaceFairy.serverConfig.creative_flight) {
            this.addAbility(new AbilityFlying().setFlightEnabled(RaceFairy.serverConfig.creative_flight).setSpeedEnabled(RaceFairy.serverConfig.creative_flight_speed).setFlightSpeed((float)RaceFairy.serverConfig.flight_speed).setFlightCost(RaceFairy.serverConfig.flight_cost));
        }
        if (RaceFairy.serverConfig.climbing) {
            this.addAbility(new AbilityClimbing());
        }
    }

    @Override
    public void whileTransformed() {
        Entity mount;
        if (!this.entity.field_70170_p.field_72995_K && this.entity.func_184218_aH() && (mount = this.entity.func_184187_bx()) != null && !this.mountEntity(mount)) {
            this.entity.func_184210_p();
        }
    }

    @Override
    public boolean canFly() {
        return super.canFly() && this.showTraits();
    }

    @Override
    public boolean mountEntity(Entity mount) {
        EntityBoat boat;
        Entity controller;
        if (this.isCreativePlayer()) {
            return true;
        }
        if (!RaceFairy.serverConfig.canMount) {
            return false;
        }
        if (!disallowedMounts.isEmpty()) {
            try {
                EntityBoat boat2;
                Entity controller2;
                boolean exists;
                ResourceLocation regName = EntityRegistry.getEntry(mount.getClass()).getRegistryName();
                String modID = regName.func_110624_b();
                String entityID = regName.func_110623_a();
                boolean bl = exists = disallowedMounts.contains(modID + ":*") || disallowedMounts.contains(regName.toString());
                if (exists) {
                    EntityBoat boat3;
                    Entity controller3;
                    if (!RaceFairy.serverConfig.canControlBoats && mount instanceof EntityBoat && ((controller3 = (boat3 = (EntityBoat)mount).func_184179_bs()) == null || controller3 == this.entity)) {
                        return false;
                    }
                    return RaceFairy.serverConfig.whitelist;
                }
                if (!RaceFairy.serverConfig.canControlBoats && mount instanceof EntityBoat && ((controller2 = (boat2 = (EntityBoat)mount).func_184179_bs()) == null || controller2 == this.entity)) {
                    return false;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return !RaceFairy.serverConfig.whitelist;
        }
        return RaceFairy.serverConfig.canControlBoats || !(mount instanceof EntityBoat) || (controller = (boat = (EntityBoat)mount).func_184179_bs()) != null && controller != this.entity;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void doRenderLayer(RenderLivingBase renderer, boolean isFake, boolean isSlim, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        if (!TrinketsConfig.CLIENT.rendering) {
            return;
        }
        if (this.showTraits()) {
            GlStateManager.func_179094_E();
            if (isFake || this.getTraitVariant() == 2) {
                GlStateManager.func_179094_E();
                if (renderer instanceof RenderPlayer) {
                    RenderPlayer r = (RenderPlayer)renderer;
                    r.func_177087_b().field_78115_e.func_78794_c(scale);
                }
                if (this.entity.func_190630_a(EntityEquipmentSlot.CHEST)) {
                    GlStateManager.func_179109_b((float)0.0f, (float)-0.1f, (float)0.06f);
                    GlStateManager.func_179152_a((float)1.1f, (float)1.1f, (float)1.1f);
                }
                if (this.entity.func_70093_af()) {
                    GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-0.1f);
                }
                GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
                this.wings.func_78088_a((Entity)this.entity, this.entity.field_184619_aG, this.entity.field_70721_aZ, (float)this.entity.field_70173_aa, this.entity.field_70177_z, this.entity.field_70125_A, 1.0f);
                GlStateManager.func_179121_F();
            } else {
                float flap = MathHelper.func_76134_b((float)(limbSwing * 0.6662f + (float)Math.PI));
                int angle = 54;
                if (!this.entity.field_70122_E || flap != this.armSwing) {
                    this.tick += 6;
                }
                if (this.tick > 54 || flap == this.armSwing && this.entity.field_70122_E) {
                    this.tick = 0;
                }
                if (this.entity.func_70093_af()) {
                    GlStateManager.func_179109_b((float)0.0f, (float)0.2f, (float)0.0f);
                }
                if (renderer instanceof RenderPlayer) {
                    RenderPlayer rend = (RenderPlayer)renderer;
                    rend.func_177087_b().field_78115_e.func_78794_c(scale);
                }
                GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
                GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179109_b((float)0.0f, (float)-2.0f, (float)0.0f);
                if (this.entity.func_190630_a(EntityEquipmentSlot.CHEST)) {
                    GlStateManager.func_179109_b((float)-0.4f, (float)-1.0f, (float)0.0f);
                }
                double x = 18.0;
                double y = 0.0;
                double z = -1.0;
                int barWidth = 16;
                int barHeight = 16;
                int barCutoffWidth = 36;
                int barCutoffHeight = 42;
                int texWidth = 36;
                int texHeight = 42;
                GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
                GlStateManager.func_179140_f();
                GlStateManager.func_179129_p();
                GlStateManager.func_179147_l();
                GlStateManager.func_179094_E();
                GlStateManager.func_179114_b((float)(54 - this.tick), (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179109_b((float)-1.0f, (float)0.0f, (float)0.0f);
                float[] rgb = ColorHelper.getRGBColor(this.getTraitVariant() == 1 ? this.getAltTraitColor() : this.getTraitColor());
                DrawingHelper.Draw(TEXTURE, -18.0, 0.0, -1.0, 0.0f, 0.0f, 36, 42, 16.0, 16.0, 36.0f, 42.0f, rgb[0], rgb[1], rgb[2], 1.0f);
                GlStateManager.func_179121_F();
                GlStateManager.func_179094_E();
                GlStateManager.func_179114_b((float)(-54 + this.tick), (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179109_b((float)-1.0f, (float)0.0f, (float)0.0f);
                DrawingHelper.Draw(TEXTURE, -18.0, 0.0, 1.0, 0.0f, 0.0f, 36, 42, 16.0, 16.0, 36.0f, 42.0f, rgb[0], rgb[1], rgb[2], 1.0f);
                GlStateManager.func_179121_F();
                GlStateManager.func_179145_e();
                GlStateManager.func_179089_o();
                GlStateManager.func_179084_k();
                this.armSwing = flap;
            }
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179121_F();
        }
    }
}

