/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.network;

import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.relauncher.Side;
import xzeroair.trinkets.api.TrinketHelper;
import xzeroair.trinkets.capabilities.Capabilities;
import xzeroair.trinkets.network.ThreadSafePacket;
import xzeroair.trinkets.util.compat.baubles.BaublesHelper;

public class SyncItemDataPacket
extends ThreadSafePacket {
    NBTTagCompound tag;
    int slot;
    int handler;
    int entityID;
    ItemStack item;
    boolean syncStacks;
    boolean equipped;

    public SyncItemDataPacket() {
    }

    public SyncItemDataPacket(EntityLivingBase player, ItemStack stack, NBTTagCompound tag, int slot, TrinketHelper.SlotInformation.ItemHandlerType handler, boolean syncSlot, boolean equipped) {
        this(player, stack, tag, slot, handler.getId(), syncSlot, equipped);
    }

    public SyncItemDataPacket(EntityLivingBase player, ItemStack stack, NBTTagCompound tag, int slot, int handler, boolean syncSlot, boolean equipped) {
        this.slot = slot;
        this.handler = handler;
        this.tag = tag == null ? new NBTTagCompound() : tag;
        this.syncStacks = syncSlot;
        this.equipped = equipped;
        if (syncSlot) {
            this.item = stack;
        }
        this.entityID = player.func_145782_y();
    }

    public SyncItemDataPacket(EntityLivingBase player, ItemStack stack, NBTTagCompound tag, int slot, int handler) {
        this(player, stack, tag, slot, handler, false, true);
    }

    @Override
    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.slot);
        buf.writeInt(this.handler);
        buf.writeInt(this.entityID);
        buf.writeBoolean(this.syncStacks);
        buf.writeBoolean(this.equipped);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.tag);
        if (this.syncStacks) {
            ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.item);
        }
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        this.slot = buf.readInt();
        this.handler = buf.readInt();
        this.entityID = buf.readInt();
        this.syncStacks = buf.readBoolean();
        this.equipped = buf.readBoolean();
        this.tag = ByteBufUtils.readTag((ByteBuf)buf);
        if (this.syncStacks) {
            this.item = ByteBufUtils.readItemStack((ByteBuf)buf);
        }
    }

    private void handlePacket(EntityLivingBase entity, Side side) {
        try {
            TrinketHelper.SlotInformation.ItemHandlerType typeHandler = TrinketHelper.SlotInformation.ItemHandlerType.byID(this.handler);
            if (typeHandler.equals((Object)TrinketHelper.SlotInformation.ItemHandlerType.TRINKETS)) {
                try {
                    this.handleTrinkets(entity, side);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (typeHandler.equals((Object)TrinketHelper.SlotInformation.ItemHandlerType.BAUBLES)) {
                try {
                    this.handleBaubles(entity, side);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void handleTrinkets(EntityLivingBase entity, Side side) {
        TrinketHelper.getTrinketHandler(entity, trinkets2 -> {
            if (this.equipped) {
                if (this.syncStacks && this.item != null && !this.item.func_190926_b()) {
                    trinkets2.setStackInSlot(this.slot, this.item);
                }
                ItemStack stack = trinkets2.getStackInSlot(this.slot);
                Capabilities.getTrinketProperties(stack, properties -> {
                    if (side.isClient()) {
                        properties.itemEquipped(stack, entity);
                        properties.loadFromNBT(this.tag);
                    } else {
                        properties.scheduleResync();
                    }
                });
            } else if (this.syncStacks) {
                trinkets2.setStackInSlot(this.slot, ItemStack.field_190927_a);
            }
        });
    }

    private void handleBaubles(EntityLivingBase entity, Side side) {
        BaublesHelper.getBaublesHandler(entity, baubles2 -> {
            if (this.equipped) {
                if (this.syncStacks && this.item != null && !this.item.func_190926_b()) {
                    baubles2.setStackInSlot(this.slot, this.item);
                }
                ItemStack stack = baubles2.getStackInSlot(this.slot);
                Capabilities.getTrinketProperties(stack, properties -> {
                    if (side.isClient()) {
                        properties.itemEquipped(stack, entity);
                        properties.loadFromNBT(this.tag);
                    } else {
                        properties.scheduleResync();
                    }
                });
            } else if (this.syncStacks) {
                baubles2.setStackInSlot(this.slot, ItemStack.field_190927_a);
            }
        });
    }

    @Override
    public void handleClientSafe(NetHandlerPlayClient client) {
        EntityPlayerSP clientPlayer = Minecraft.func_71410_x().field_71439_g;
        World world = clientPlayer.func_130014_f_();
        Entity entity = world.func_73045_a(this.entityID);
        if (entity instanceof EntityLivingBase) {
            this.handlePacket((EntityLivingBase)entity, Side.CLIENT);
        }
    }

    @Override
    public void handleServerSafe(NetHandlerPlayServer server) {
        EntityPlayerMP serverPlayer = server.field_147369_b;
        WorldServer world = serverPlayer.func_71121_q();
        Entity entity = world.func_73045_a(this.entityID);
        if (entity instanceof EntityLivingBase) {
            this.handlePacket((EntityLivingBase)entity, Side.SERVER);
        }
    }
}

