/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets;

import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.potion.PotionType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryBuilder;
import xzeroair.trinkets.Trinkets;
import xzeroair.trinkets.init.ModBlocks;
import xzeroair.trinkets.init.ModItems;
import xzeroair.trinkets.init.ModPotionTypes;
import xzeroair.trinkets.races.EntityRace;
import xzeroair.trinkets.traits.elements.Element;
import xzeroair.trinkets.util.TrinketsConfig;
import xzeroair.trinkets.util.interfaces.IAccessoryInterface;
import xzeroair.trinkets.util.interfaces.IsModelLoaded;

@Mod.EventBusSubscriber(modid="xat")
public class Registries {
    private static final ResourceLocation ELEMENTS_ID = new ResourceLocation("xat", "elements");
    private static final ResourceLocation RACES_ID = new ResourceLocation("xat", "races");
    private static ForgeRegistry<Element> elementRegistry;
    private static ForgeRegistry<EntityRace> raceRegistry;

    @SubscribeEvent
    public static void registerNewRegistry(RegistryEvent.NewRegistry event) {
        ForgeRegistry races;
        ForgeRegistry elements;
        RegistryBuilder elementReg = new RegistryBuilder();
        elementRegistry = elements = (ForgeRegistry)elementReg.setType(Element.class).allowModification().setName(ELEMENTS_ID).create();
        RegistryBuilder racesReg = new RegistryBuilder();
        raceRegistry = races = (ForgeRegistry)racesReg.setType(EntityRace.class).allowModification().setName(RACES_ID).create();
    }

    public static ForgeRegistry<Element> getElementRegistry() {
        return elementRegistry;
    }

    public static ForgeRegistry<EntityRace> getRaceRegistry() {
        return raceRegistry;
    }

    @SubscribeEvent
    public static void registerItem(RegistryEvent.Register<Item> event) {
        Trinkets.log.info("Registering Crafting");
        event.getRegistry().registerAll((IForgeRegistryEntry[])ModItems.crafting.ITEMS.toArray(new Item[0]));
        if (TrinketsConfig.SERVER.Food.foods_enabled) {
            Trinkets.log.info("Registering Foods");
            event.getRegistry().registerAll((IForgeRegistryEntry[])ModItems.foods.ITEMS.toArray(new Item[0]));
        }
        Trinkets.log.info("Registering Misc");
        event.getRegistry().registerAll((IForgeRegistryEntry[])ModItems.misc.ITEMS.toArray(new Item[0]));
        if (Trinkets.Baubles && !TrinketsConfig.compat.xatItemsInTrinketGuiOnly) {
            Trinkets.log.info("Registering Baubles");
            for (Item item : ModItems.baubles.ITEMS) {
                if (!(item instanceof IAccessoryInterface) || !((IAccessoryInterface)item).ItemEnabled()) continue;
                event.getRegistry().register((IForgeRegistryEntry)item);
            }
        } else {
            Trinkets.log.info("Registering Trinkets");
            for (Item item : ModItems.trinkets.ITEMS) {
                if (!(item instanceof IAccessoryInterface) || !((IAccessoryInterface)item).ItemEnabled()) continue;
                event.getRegistry().register((IForgeRegistryEntry)item);
            }
            Trinkets.log.info("Registering Race Trinkets");
            for (Item item : ModItems.RaceTrinkets.ITEMS) {
                if (!(item instanceof IAccessoryInterface) || !((IAccessoryInterface)item).ItemEnabled()) continue;
                event.getRegistry().register((IForgeRegistryEntry)item);
            }
        }
    }

    @SubscribeEvent
    public static void registerBlock(RegistryEvent.Register<Block> event) {
        Trinkets.log.info("Registering Flower Blocks");
        event.getRegistry().registerAll((IForgeRegistryEntry[])ModBlocks.Flowers.BLOCKS.toArray(new Block[0]));
        Trinkets.log.info("Registering Placeable Blocks");
        event.getRegistry().registerAll((IForgeRegistryEntry[])ModBlocks.Placeables.BLOCKS.toArray(new Block[0]));
    }

    @SubscribeEvent
    public static void registerPotion(RegistryEvent.Register<PotionType> event) {
        if (TrinketsConfig.SERVER.Potion.potions_enabled) {
            Trinkets.log.info("Registering Potions");
            ModPotionTypes.registerPotionTypes();
        }
    }

    @SubscribeEvent
    public static void registerModel(ModelRegistryEvent event) {
        for (Item item : ModItems.misc.ITEMS) {
            if (!(item instanceof IsModelLoaded)) continue;
            ((IsModelLoaded)item).registerModels();
        }
        for (Item item : ModItems.crafting.ITEMS) {
            if (!(item instanceof IsModelLoaded)) continue;
            ((IsModelLoaded)item).registerModels();
        }
        for (Block block : ModBlocks.Flowers.BLOCKS) {
            if (!(block instanceof IsModelLoaded)) continue;
            ((IsModelLoaded)block).registerModels();
        }
        for (Block block : ModBlocks.Placeables.BLOCKS) {
            if (!(block instanceof IsModelLoaded)) continue;
            ((IsModelLoaded)block).registerModels();
        }
        if (TrinketsConfig.SERVER.Food.foods_enabled) {
            for (Item item : ModItems.foods.ITEMS) {
                if (!(item instanceof IsModelLoaded)) continue;
                ((IsModelLoaded)item).registerModels();
            }
        }
        if (Trinkets.Baubles && !TrinketsConfig.compat.xatItemsInTrinketGuiOnly) {
            for (Item item : ModItems.baubles.ITEMS) {
                if (!(item instanceof IsModelLoaded)) continue;
                ((IsModelLoaded)item).registerModels();
            }
        } else {
            for (Item item : ModItems.trinkets.ITEMS) {
                if (!(item instanceof IsModelLoaded)) continue;
                ((IsModelLoaded)item).registerModels();
            }
            for (Item item : ModItems.RaceTrinkets.ITEMS) {
                if (!(item instanceof IsModelLoaded)) continue;
                ((IsModelLoaded)item).registerModels();
            }
        }
    }
}

