/*
 * Decompiled with CFR 0.152.
 */
package io.github.xcube16.iseedragons.asm.patch;

import io.github.xcube16.iseedragons.ISD;
import io.github.xcube16.iseedragons.asm.ISeeDragonsTransformer;
import io.github.xcube16.iseedragons.asm.Patch;
import io.github.xcube16.iseedragons.asm.PatchResult;
import io.github.xcube16.iseedragons.asm.Patcher;
import java.util.Optional;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

@Patcher(name="Fix Dragon Item Lag", config="DragonLag")
public class PatchDragonItemLag {
    @Patch(target="com.github.alexthe666.iceandfire.entity.EntityDragonBase", desc="hooks into EntityDragonBase#breakBlock to spawn less items")
    public static PatchResult fixEntityDragonBase(ISeeDragonsTransformer tweaker, ClassNode node) {
        AbstractInsnNode breakBlockCall;
        Optional<MethodNode> breakBlockMethod = node.methods.stream().filter(method -> method.name.equals("breakBlock")).findFirst();
        if (!breakBlockMethod.isPresent()) {
            ISD.logger.warn("Failed to find breakBlock() method");
            return PatchResult.NO_MUTATION;
        }
        for (breakBlockCall = breakBlockMethod.get().instructions.getFirst(); !(breakBlockCall == null || breakBlockCall.getOpcode() == 182 && ((MethodInsnNode)breakBlockCall).name.equals("func_175655_b")); breakBlockCall = breakBlockCall.getNext()) {
        }
        if (breakBlockCall == null) {
            ISD.logger.error("Failed to find func_175655_b (World#destroyBlock()) call");
            return PatchResult.NO_MUTATION;
        }
        breakBlockMethod.get().instructions.remove(breakBlockCall.getPrevious());
        InsnList callHook = new InsnList();
        callHook.add((AbstractInsnNode)new VarInsnNode(25, 5));
        callHook.add((AbstractInsnNode)new MethodInsnNode(184, "io/github/xcube16/iseedragons/ISeeDragons", "dragonBreakBlockHook", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/state/IBlockState;)Z"));
        breakBlockMethod.get().instructions.insertBefore(breakBlockCall, callHook);
        breakBlockMethod.get().instructions.remove(breakBlockCall);
        return PatchResult.NO_FLAGS;
    }
}

