/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.legendarytooltips.render;

import com.anthonyhilyard.legendarytooltips.LegendaryTooltipsConfig;
import com.anthonyhilyard.legendarytooltips.util.GuiHelper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.client.config.GuiUtils;

public class TooltipDecor {
    private static final ResourceLocation TEXTURE_TOOLTIP_BORDERS = new ResourceLocation("legendarytooltips", "textures/gui/tooltip_borders.png");
    private static int currentTooltipBorderStart = 0;
    private static int currentTooltipBorderEnd = 0;
    private static Map<Integer, Integer> shineTimers = new HashMap<Integer, Integer>(){
        {
            this.put(0, 0);
        }
    };
    private static Map<Integer, List<String>> cachedPreWrapLines = new HashMap<Integer, List<String>>();

    public static void setCurrentTooltipBorderStart(int color) {
        currentTooltipBorderStart = color;
    }

    public static void setCurrentTooltipBorderEnd(int color) {
        currentTooltipBorderEnd = color;
    }

    public static void setCachedLines(List<String> lines, int index) {
        cachedPreWrapLines.put(index, lines);
    }

    public static void updateTimers() {
        for (Integer index : shineTimers.keySet()) {
            shineTimers.put(index, shineTimers.get(index) - 1);
        }
    }

    public static void resetTimer(int index) {
        shineTimers.put(index, LegendaryTooltipsConfig.INSTANCE.shineTicks);
    }

    public static void resetTimers() {
        for (Integer index : shineTimers.keySet()) {
            TooltipDecor.resetTimer(index);
        }
    }

    public static void drawShadow(int x, int y, int width, int height) {
        int shadowColor = 0x44000000;
        GuiUtils.drawGradientRect((int)390, (int)(x - 1), (int)(y + height + 4), (int)(x + width + 4), (int)(y + height + 5), (int)shadowColor, (int)shadowColor);
        GuiUtils.drawGradientRect((int)390, (int)(x + width + 4), (int)(y - 1), (int)(x + width + 5), (int)(y + height + 5), (int)shadowColor, (int)shadowColor);
        GuiUtils.drawGradientRect((int)390, (int)(x + width + 3), (int)(y + height + 3), (int)(x + width + 4), (int)(y + height + 4), (int)shadowColor, (int)shadowColor);
        GuiUtils.drawGradientRect((int)390, (int)x, (int)(y + height + 5), (int)(x + width + 5), (int)(y + height + 6), (int)shadowColor, (int)shadowColor);
        GuiUtils.drawGradientRect((int)390, (int)(x + width + 5), (int)y, (int)(x + width + 6), (int)(y + height + 5), (int)shadowColor, (int)shadowColor);
    }

    public static void drawSeparator(int x, int y, int width, int color) {
        GuiHelper.drawGradientRectHorizontal(402, x, y, x + width / 2, y + 1, color & 0xFFFFFF, color);
        GuiHelper.drawGradientRectHorizontal(402, x + width / 2, y, x + width, y + 1, color, color & 0xFFFFFF);
    }

    private static double lerp(double t, double a, double b) {
        return a + t * (b - a);
    }

    public static void drawBorder(int x, int y, int width, int height, ItemStack item, List<String> lines, FontRenderer font, int frameLevel, boolean comparison, int index) {
        if (comparison) {
            GuiUtils.drawGradientRect((int)400, (int)(x - 3), (int)(y - 3 + 1), (int)(x - 3 + 1), (int)(y + height + 3 - 1), (int)currentTooltipBorderStart, (int)currentTooltipBorderEnd);
            GuiUtils.drawGradientRect((int)400, (int)(x + width + 2), (int)(y - 3 + 1), (int)(x + width + 3), (int)(y + height + 3 - 1), (int)currentTooltipBorderStart, (int)currentTooltipBorderEnd);
            GuiUtils.drawGradientRect((int)400, (int)(x - 3), (int)(y - 3), (int)(x + width + 3), (int)(y - 3 + 1), (int)currentTooltipBorderStart, (int)currentTooltipBorderStart);
            GuiUtils.drawGradientRect((int)400, (int)(x - 3), (int)(y + height + 2), (int)(x + width + 3), (int)(y + height + 3), (int)currentTooltipBorderEnd, (int)currentTooltipBorderEnd);
            TooltipDecor.drawSeparator(x - 3 + 1, y - 3 + 1 + 10, width, currentTooltipBorderStart);
        }
        if (LegendaryTooltipsConfig.INSTANCE.nameSeparator && item != null && !item.func_190926_b()) {
            String textLine = null;
            if (cachedPreWrapLines.containsKey(index)) {
                textLine = cachedPreWrapLines.get(index).get(0);
            } else if (cachedPreWrapLines.containsKey(0)) {
                index = 0;
                textLine = cachedPreWrapLines.get(0).get(0);
            }
            if (textLine != null) {
                List wrappedLine = font.func_78271_c(textLine, width);
                int titleLineCount = wrappedLine.size();
                if (cachedPreWrapLines.get(index).size() > titleLineCount) {
                    int offset = 0;
                    if (comparison) {
                        offset = 11;
                    }
                    TooltipDecor.drawSeparator(x - 3 + 1, y - 3 + 1 + titleLineCount * 10 + 1 + offset, width, currentTooltipBorderStart);
                }
            }
        }
        if (frameLevel >= 16 || frameLevel < 0) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        mc.func_110434_K().func_110577_a(TEXTURE_TOOLTIP_BORDERS);
        int textureWidth = GlStateManager.func_187411_c((int)3553, (int)0, (int)4096);
        int textureHeight = GlStateManager.func_187411_c((int)3553, (int)0, (int)4097);
        if (LegendaryTooltipsConfig.INSTANCE.shineEffect) {
            int verticalInterval;
            int verticalMax;
            int verticalMin;
            int alpha;
            float interval;
            if (!shineTimers.containsKey(index)) {
                shineTimers.put(index, LegendaryTooltipsConfig.INSTANCE.shineTicks);
            }
            int maxTick = LegendaryTooltipsConfig.INSTANCE.shineTicks;
            if ((float)shineTimers.get(index).intValue() >= (float)maxTick * 0.2f && (float)shineTimers.get(index).intValue() <= (float)maxTick * 0.8f) {
                interval = MathHelper.func_76131_a((float)(((float)shineTimers.get(index).intValue() - (float)maxTick * 0.2f) / ((float)maxTick * 0.6f)), (float)0.0f, (float)1.0f);
                alpha = (int)(153.0f * interval) << 24;
                int horizontalMin = x - 3;
                int horizontalMax = x + width + 3;
                int horizontalInterval = (int)TooltipDecor.lerp(interval * interval, horizontalMax, horizontalMin);
                GuiHelper.drawGradientRectHorizontal(402, Math.max(horizontalInterval - 36, horizontalMin), y - 3, Math.min(horizontalInterval, horizontalMax), y - 3 + 1, 0xFFFFFF, 0xFFFFFF | alpha);
                GuiHelper.drawGradientRectHorizontal(402, Math.max(horizontalInterval, horizontalMin), y - 3, Math.min(horizontalInterval + 36, horizontalMax), y - 3 + 1, 0xFFFFFF | alpha, 0xFFFFFF);
            }
            if (LegendaryTooltipsConfig.INSTANCE.shineSync) {
                if ((float)shineTimers.get(index).intValue() >= (float)maxTick * 0.2f && (float)shineTimers.get(index).intValue() <= (float)maxTick * 0.8f) {
                    interval = MathHelper.func_76131_a((float)(((float)shineTimers.get(index).intValue() - (float)maxTick * 0.2f) / ((float)maxTick * 0.6f)), (float)0.0f, (float)1.0f);
                    alpha = (int)(85.0f * interval) << 24;
                    verticalMin = y - 3 + 1;
                    verticalMax = y + height + 3 - 1;
                    verticalInterval = (int)TooltipDecor.lerp(interval * interval, verticalMax, verticalMin);
                    GuiUtils.drawGradientRect((int)402, (int)(x - 3), (int)Math.max(verticalInterval - 12, verticalMin), (int)(x - 3 + 1), (int)Math.min(verticalInterval, verticalMax), (int)0xFFFFFF, (int)(0xFFFFFF | alpha));
                    GuiUtils.drawGradientRect((int)402, (int)(x - 3), (int)Math.max(verticalInterval, verticalMin), (int)(x - 3 + 1), (int)Math.min(verticalInterval + 12, verticalMax), (int)(0xFFFFFF | alpha), (int)0xFFFFFF);
                }
            } else if ((float)shineTimers.get(index).intValue() <= (float)maxTick * 0.4f) {
                interval = MathHelper.func_76131_a((float)((float)shineTimers.get(index).intValue() / ((float)maxTick * 0.4f)), (float)0.0f, (float)1.0f);
                alpha = (int)(85.0f * interval) << 24;
                verticalMin = y - 3 + 1;
                verticalMax = y + height + 3 - 1;
                verticalInterval = (int)TooltipDecor.lerp(interval * interval, verticalMax, verticalMin);
                GuiUtils.drawGradientRect((int)402, (int)(x - 3), (int)Math.max(verticalInterval - 12, verticalMin), (int)(x - 3 + 1), (int)Math.min(verticalInterval, verticalMax), (int)0xFFFFFF, (int)(0xFFFFFF | alpha));
                GuiUtils.drawGradientRect((int)402, (int)(x - 3), (int)Math.max(verticalInterval, verticalMin), (int)(x - 3 + 1), (int)Math.min(verticalInterval + 12, verticalMax), (int)(0xFFFFFF | alpha), (int)0xFFFFFF);
            }
            if (shineTimers.get(index) <= 0 && LegendaryTooltipsConfig.INSTANCE.shineRepeat) {
                TooltipDecor.resetTimers();
            }
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)410.0);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Gui.func_146110_a((int)(x - 6), (int)(y - 6), (float)(frameLevel / 8 * 64), (float)(frameLevel * 16 % textureHeight), (int)8, (int)8, (float)textureWidth, (float)textureHeight);
        Gui.func_146110_a((int)(x + width - 8 + 6), (int)(y - 6), (float)(56 + frameLevel / 8 * 64), (float)(frameLevel * 16 % textureHeight), (int)8, (int)8, (float)textureWidth, (float)textureHeight);
        Gui.func_146110_a((int)(x - 6), (int)(y + height - 8 + 6), (float)(frameLevel / 8 * 64), (float)(frameLevel * 16 % textureHeight + 8), (int)8, (int)8, (float)textureWidth, (float)textureHeight);
        Gui.func_146110_a((int)(x + width - 8 + 6), (int)(y + height - 8 + 6), (float)(56 + frameLevel / 8 * 64), (float)(frameLevel * 16 % textureHeight + 8), (int)8, (int)8, (float)textureWidth, (float)textureHeight);
        if (width >= 48) {
            Gui.func_146110_a((int)(x + width / 2 - 24), (int)(y - 9), (float)(8 + frameLevel / 8 * 64), (float)(frameLevel * 16 % textureHeight), (int)48, (int)8, (float)textureWidth, (float)textureHeight);
            Gui.func_146110_a((int)(x + width / 2 - 24), (int)(y + height - 8 + 9), (float)(8 + frameLevel / 8 * 64), (float)(frameLevel * 16 % textureHeight + 8), (int)48, (int)8, (float)textureWidth, (float)textureHeight);
        }
        GlStateManager.func_179121_F();
    }
}

