/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.vecmath.Point2d;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;

public class AABBUtil {
    public static AxisAlignedBB rotate(AxisAlignedBB aabb, EnumFacing facing) {
        Point2d pointMin = AABBUtil.rotate(new Point2d(aabb.field_72340_a, aabb.field_72339_c), facing);
        Point2d pointMax = AABBUtil.rotate(new Point2d(aabb.field_72336_d, aabb.field_72334_f), facing);
        return new AxisAlignedBB(pointMin.x, aabb.field_72338_b, pointMin.y, pointMax.x, aabb.field_72337_e, pointMax.y);
    }

    public static Point2d rotate(Point2d point, EnumFacing facing) {
        double x = point.x - 0.5;
        double y = point.y - 0.5;
        Point2d pointNew = new Point2d();
        double d = pointNew.x = facing.func_176736_b() % 2 == 0 ? x : y;
        if (facing.func_176736_b() < 2) {
            pointNew.x *= -1.0;
        }
        double d2 = pointNew.y = facing.func_176736_b() % 2 == 0 ? y : x;
        if (facing.func_176736_b() == 0 || facing.func_176736_b() == 3) {
            pointNew.y *= -1.0;
        }
        pointNew.x += 0.5;
        pointNew.y += 0.5;
        return pointNew;
    }

    public static int rayTraceByDistance(EntityPlayer player, List<AxisAlignedBB> aabbs) {
        Vec3d posPlayer = player.func_174824_e(1.0f);
        ArrayList sorted = Lists.newArrayList(aabbs);
        sorted.sort(Comparator.comparingDouble(o -> AABBUtil.getCenter(o).func_72436_e(posPlayer)));
        for (AxisAlignedBB aabb : sorted) {
            if (AABBUtil.rayTrace(player, aabb) == null) continue;
            return aabbs.indexOf(aabb);
        }
        return -1;
    }

    public static RayTraceResult rayTrace(EntityPlayer player, AxisAlignedBB aabb) {
        Vec3d posPlayer = player.func_174824_e(1.0f);
        double distance = player.func_110148_a(EntityPlayer.REACH_DISTANCE).func_111126_e();
        Vec3d posEnd = posPlayer.func_178787_e(player.func_70040_Z().func_186678_a(distance));
        return aabb.func_72327_a(posPlayer, posEnd);
    }

    public static Vec3d getCenter(AxisAlignedBB aabb) {
        return new Vec3d(aabb.field_72340_a + (aabb.field_72336_d - aabb.field_72340_a) * 0.5, aabb.field_72338_b + (aabb.field_72337_e - aabb.field_72338_b) * 0.5, aabb.field_72339_c + (aabb.field_72334_f - aabb.field_72339_c) * 0.5);
    }
}

