/*
 * Decompiled with CFR 0.152.
 */
package tschipp.callablehorses.client.gui;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AbstractAttributeMap;
import net.minecraft.entity.passive.AbstractHorse;
import net.minecraft.entity.passive.EntityLlama;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import tschipp.callablehorses.common.capabilities.horseowner.IHorseOwner;
import tschipp.callablehorses.common.helper.HorseHelper;

public class GuiStatViewer
extends GuiScreen {
    private int xSize = 176;
    private int ySize = 138;
    private static final ResourceLocation TEXTURE = new ResourceLocation("callablehorses", "textures/gui/horse_stat_viewer.png");
    private EntityPlayer player;
    private IHorseOwner owner;
    private AbstractHorse horse;
    private float speed;
    private float jumpHeight;
    private float health;
    private float maxHealth;
    private BlockPos lastPos;
    private int lastDim;
    private String lastDimString;

    public GuiStatViewer(EntityPlayer player) {
        Method setColor;
        this.player = player;
        this.owner = HorseHelper.getOwnerCap(player);
        this.horse = this.owner.getHorseEntity(player.field_70170_p);
        SharedMonsterAttributes.func_151475_a((AbstractAttributeMap)this.horse.func_110140_aT(), (NBTTagList)this.owner.getHorseNBT().func_150295_c("Attributes", 10));
        this.horse.func_70020_e(this.owner.getHorseNBT());
        IItemHandler horseInventory = (IItemHandler)this.horse.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        this.horse.func_110251_o(!horseInventory.getStackInSlot(0).func_190926_b() && this.horse.func_190685_dA());
        if (this.horse instanceof EntityLlama && (setColor = ReflectionHelper.findMethod(EntityLlama.class, (String)"setColor", (String)"func_190711_a", (Class[])new Class[]{EnumDyeColor.class})) != null) {
            try {
                ItemStack stack = horseInventory.getStackInSlot(1);
                if (this.horse.func_190682_f(stack)) {
                    setColor.invoke((Object)this.horse, EnumDyeColor.func_176764_b((int)stack.func_77960_j()));
                } else {
                    setColor.invoke((Object)this.horse, new Object[]{null});
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        this.health = (float)Math.floor(this.horse.func_110143_aJ());
        this.maxHealth = (float)(Math.floor(this.horse.func_110138_aP() * 10.0f) / 10.0);
        this.speed = (float)(Math.floor(this.horse.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e() * 100.0) / 10.0);
        this.jumpHeight = (float)(Math.floor(this.horse.func_110215_cj() * 100.0) / 10.0);
        this.lastPos = this.owner.getLastSeenPosition();
        this.lastDim = this.owner.getLastSeenDim();
        this.lastDimString = DimensionManager.getProviderType((int)this.lastDim).func_186065_b();
    }

    public void func_73866_w_() {
        super.func_73866_w_();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(TEXTURE);
        int i = (this.field_146294_l - this.xSize) / 2;
        int j = (this.field_146295_m - this.ySize) / 2;
        this.func_73729_b(i, j, 0, 0, this.xSize, this.ySize);
        super.func_73863_a(mouseX, mouseY, partialTicks);
        GuiInventory.func_147046_a((int)(i + 43), (int)(j + 68), (int)25, (float)((float)(i + 51) - (float)mouseX), (float)((float)(j + 75 - 50) - (float)mouseY), (EntityLivingBase)this.horse);
        this.func_73731_b(this.field_146289_q, this.horse.func_70005_c_(), i + 84, j + 10, EnumDyeColor.WHITE.func_193350_e());
        this.func_73731_b(this.field_146289_q, "Health:", i + 84, j + 30, EnumDyeColor.SILVER.func_193350_e());
        this.func_73731_b(this.field_146289_q, this.health + "/" + this.maxHealth, i + 120, j + 30, EnumDyeColor.WHITE.func_193350_e());
        this.func_73731_b(this.field_146289_q, "Speed:", i + 84, j + 45, EnumDyeColor.SILVER.func_193350_e());
        this.func_73731_b(this.field_146289_q, this.speed + "", i + 120, j + 45, EnumDyeColor.WHITE.func_193350_e());
        this.func_73731_b(this.field_146289_q, "Jump Height:", i + 84, j + 60, EnumDyeColor.SILVER.func_193350_e());
        this.func_73731_b(this.field_146289_q, this.jumpHeight + "", i + 148, j + 60, EnumDyeColor.WHITE.func_193350_e());
        this.func_73731_b(this.field_146289_q, "Last known position:", i + 8, j + 84, EnumDyeColor.SILVER.func_193350_e());
        this.func_73731_b(this.field_146289_q, this.lastPos.equals((Object)BlockPos.field_177992_a) ? "Unknown" : "xyz = " + this.lastPos.func_177958_n() + " " + this.lastPos.func_177956_o() + " " + this.lastPos.func_177952_p(), i + 8, j + 94, EnumDyeColor.WHITE.func_193350_e());
        this.func_73731_b(this.field_146289_q, "Last known dimension:", i + 8, j + 110, EnumDyeColor.SILVER.func_193350_e());
        this.func_73731_b(this.field_146289_q, this.lastDimString, i + 8, j + 120, EnumDyeColor.WHITE.func_193350_e());
    }

    public boolean func_73868_f() {
        return false;
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        super.func_73869_a(typedChar, keyCode);
        if (this.field_146297_k.field_71474_y.field_151445_Q.isActiveAndMatches(keyCode)) {
            this.field_146297_k.field_71439_g.func_71053_j();
        }
    }
}

