/*
 * Decompiled with CFR 0.152.
 */
package cursedflames.bountifulbaubles.wormhole;

import cursedflames.bountifulbaubles.network.NBTPacket;
import cursedflames.bountifulbaubles.network.PacketHandler;
import cursedflames.bountifulbaubles.wormhole.WormholeUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class TeleportRequest {
    public static List<TeleportRequest> requests = new ArrayList<TeleportRequest>();
    public static int REQ_EXPIRY_TIME = 400;
    public final long reqTickTime;
    public final World world;
    public final UUID origin;
    public final UUID target;
    public Status status = Status.PENDING;

    private TeleportRequest(World world, UUID origin, UUID target) {
        this.reqTickTime = world.func_82737_E();
        this.world = world;
        this.origin = origin;
        this.target = target;
    }

    public static TeleportRequest makeReq(World world, EntityPlayer origin, EntityPlayer target) {
        if (!(target instanceof EntityPlayerMP)) {
            return null;
        }
        origin.func_145747_a((ITextComponent)new TextComponentString("Teleport request sent to " + target.func_70005_c_()));
        TeleportRequest req = new TeleportRequest(world, origin.func_110124_au(), target.func_110124_au());
        requests.add(req);
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_186854_a("sender", origin.func_110124_au());
        tag.func_74778_a("name", origin.func_70005_c_());
        NBTPacket clientReq = new NBTPacket(tag, PacketHandler.HandlerIds.WORMHOLE_REQUEST.id);
        PacketHandler.INSTANCE.sendTo((IMessage)clientReq, (EntityPlayerMP)target);
        return req;
    }

    public static void acceptReject(EntityPlayer target, boolean accept, String name) {
        UUID origin;
        long timeoutTime = target.field_70170_p.func_82737_E() - (long)REQ_EXPIRY_TIME;
        EntityPlayer originPlayer = null;
        if (name == null || name.length() == 0) {
            origin = null;
        } else {
            originPlayer = target.field_70170_p.func_72924_a(name);
            if (originPlayer == null) {
                return;
            }
            origin = originPlayer.func_110124_au();
        }
        for (int i = requests.size() - 1; i >= 0; --i) {
            TeleportRequest req = requests.get(i);
            if (req.reqTickTime < timeoutTime) {
                req.status = Status.TIMEOUT;
                EntityPlayer from = target.field_70170_p.func_152378_a(req.origin);
                EntityPlayer to = target.field_70170_p.func_152378_a(req.target);
                if (from != null && to != null) {
                    from.func_145747_a((ITextComponent)new TextComponentString("Teleport request to " + to.func_70005_c_() + " has expired."));
                    to.func_145747_a((ITextComponent)new TextComponentString("Teleport request from " + from.func_70005_c_() + " has expired."));
                }
                requests.remove(i);
                continue;
            }
            if (!req.target.equals(target.func_110124_au()) || origin != null && !req.origin.equals(origin)) continue;
            EntityPlayer player = originPlayer;
            if (player == null) {
                player = target.field_70170_p.func_152378_a(req.origin);
            }
            if (!accept) {
                req.status = Status.REJECT;
                if (player != null) {
                    target.func_145747_a((ITextComponent)new TextComponentString("Rejected teleport request from " + player.func_70005_c_() + "."));
                    player.func_145747_a((ITextComponent)new TextComponentString("Teleport request to " + target.func_70005_c_() + " was rejected."));
                }
            } else {
                req.status = Status.ACCEPT;
                if (player != null) {
                    target.func_145747_a((ITextComponent)new TextComponentString("Accepted teleport request from " + player.func_70005_c_() + "."));
                    player.func_145747_a((ITextComponent)new TextComponentString("Teleport request to " + target.func_70005_c_() + " was accepted."));
                    TextComponentString message1 = null;
                    TextComponentString message2 = null;
                    if (player.func_70608_bn()) {
                        message1 = new TextComponentString("Teleport failed as " + player.func_70005_c_() + " is asleep.");
                        message2 = new TextComponentString("Teleport failed as you are asleep.");
                    } else if (player.func_184218_aH()) {
                        message1 = new TextComponentString("Teleport failed as " + player.func_70005_c_() + " is mounted.");
                        message2 = new TextComponentString("Teleport failed as you are mounted.");
                    } else if (WormholeUtil.consumeItem(player)) {
                        WormholeUtil.doTeleport(player, target);
                    } else {
                        message1 = new TextComponentString("Teleport failed as " + player.func_70005_c_() + " has no wormhole potions or mirror.");
                        message2 = new TextComponentString("Teleport failed as you have no wormhole potions or mirror.");
                    }
                    if (message1 != null) {
                        target.func_145747_a((ITextComponent)message1);
                    }
                    if (message2 != null) {
                        player.func_145747_a(message2);
                    }
                }
            }
            requests.remove(i);
            if (origin == null) continue;
            return;
        }
    }

    public static enum Status {
        PENDING,
        ACCEPT,
        REJECT,
        TIMEOUT;

    }
}

