/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.commands.admin;

import betterquesting.api.properties.NativeProps;
import betterquesting.api.storage.BQ_Settings;
import betterquesting.api.utils.JsonHelper;
import betterquesting.api.utils.NBTConverter;
import betterquesting.commands.QuestCommandBase;
import betterquesting.handlers.SaveLoadHandler;
import betterquesting.legacy.ILegacyLoader;
import betterquesting.legacy.LegacyLoaderRegistry;
import betterquesting.network.handlers.NetChapterSync;
import betterquesting.network.handlers.NetQuestSync;
import betterquesting.network.handlers.NetSettingSync;
import betterquesting.questing.QuestDatabase;
import betterquesting.questing.QuestLineDatabase;
import betterquesting.storage.QuestSettings;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.server.permission.DefaultPermissionLevel;

public class QuestCommandDefaults
extends QuestCommandBase {
    @Override
    public String getUsageSuffix() {
        return "[save|load|set] [file_name]";
    }

    @Override
    public boolean validArgs(String[] args) {
        return args.length == 2 || args.length == 3;
    }

    @Override
    public List<String> autoComplete(MinecraftServer server, ICommandSender sender, String[] args) {
        if (args.length == 2) {
            return CommandBase.func_71530_a((String[])args, (String[])new String[]{"save", "load", "set"});
        }
        if (args.length == 3) {
            return Collections.singletonList("DefaultQuests");
        }
        return Collections.emptyList();
    }

    @Override
    public String getCommand() {
        return "default";
    }

    @Override
    public void runCommand(MinecraftServer server, CommandBase command, ICommandSender sender, String[] args) throws CommandException {
        File qFile = args.length == 3 && !args[2].equalsIgnoreCase("DefaultQuests") ? new File(BQ_Settings.defaultDir, "saved_quests/" + args[2] + ".json") : new File(BQ_Settings.defaultDir, "DefaultQuests.json");
        if (args[1].equalsIgnoreCase("save")) {
            NBTTagCompound base = new NBTTagCompound();
            base.func_74782_a("questSettings", (NBTBase)QuestSettings.INSTANCE.writeToNBT(new NBTTagCompound()));
            base.func_74782_a("questDatabase", (NBTBase)QuestDatabase.INSTANCE.writeToNBT(new NBTTagList(), (List<Integer>)null));
            base.func_74782_a("questLines", (NBTBase)QuestLineDatabase.INSTANCE.writeToNBT(new NBTTagList(), (List<Integer>)null));
            base.func_74778_a("format", "2.0.0");
            JsonHelper.WriteToFile(qFile, NBTConverter.NBTtoJSON_Compound(base, new JsonObject(), true));
            if (args.length == 3 && !args[2].equalsIgnoreCase("DefaultQuests")) {
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("betterquesting.cmd.default.save2", new Object[]{args[2] + ".json"}));
            } else {
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("betterquesting.cmd.default.save", new Object[0]));
            }
        } else if (args[1].equalsIgnoreCase("load")) {
            if (qFile.exists()) {
                boolean editMode = QuestSettings.INSTANCE.getProperty(NativeProps.EDIT_MODE);
                boolean hardMode = QuestSettings.INSTANCE.getProperty(NativeProps.HARDCORE);
                NBTTagList jsonP = QuestDatabase.INSTANCE.writeProgressToNBT(new NBTTagList(), (List<UUID>)null);
                JsonObject j1 = JsonHelper.ReadFromFile(qFile);
                NBTTagCompound nbt1 = NBTConverter.JSONtoNBT_Object(j1, new NBTTagCompound(), true);
                ILegacyLoader loader = LegacyLoaderRegistry.getLoader(nbt1.func_150297_b("format", 8) ? nbt1.func_74779_i("format") : "0.0.0");
                if (loader == null) {
                    QuestSettings.INSTANCE.readFromNBT(nbt1.func_74775_l("questSettings"));
                    QuestDatabase.INSTANCE.readFromNBT(nbt1.func_150295_c("questDatabase", 10), false);
                    QuestLineDatabase.INSTANCE.readFromNBT(nbt1.func_150295_c("questLines", 10), false);
                } else {
                    loader.readFromJson((JsonElement)j1);
                }
                QuestDatabase.INSTANCE.readProgressFromNBT(jsonP, false);
                QuestSettings.INSTANCE.setProperty(NativeProps.EDIT_MODE, editMode);
                QuestSettings.INSTANCE.setProperty(NativeProps.HARDCORE, hardMode);
                if (args.length == 3 && !args[2].equalsIgnoreCase("DefaultQuests")) {
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation("betterquesting.cmd.default.load2", new Object[]{args[2] + ".json"}));
                } else {
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation("betterquesting.cmd.default.load", new Object[0]));
                }
                NetSettingSync.sendSync(null);
                NetQuestSync.quickSync(-1, true, true);
                NetChapterSync.sendSync(null, null);
                SaveLoadHandler.INSTANCE.markDirty();
            } else {
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("betterquesting.cmd.default.none", new Object[0]));
            }
        } else if (args[1].equalsIgnoreCase("set") && args.length == 3) {
            if (qFile.exists() && !args[2].equalsIgnoreCase("DefaultQuests")) {
                File defFile = new File(BQ_Settings.defaultDir, "DefaultQuests.json");
                if (defFile.exists()) {
                    defFile.delete();
                }
                JsonHelper.CopyPaste(qFile, defFile);
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("betterquesting.cmd.default.set", new Object[]{args[2]}));
            } else {
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("betterquesting.cmd.default.none", new Object[0]));
            }
        } else {
            throw this.getException(command);
        }
    }

    @Override
    public String getPermissionNode() {
        return "betterquesting.command.admin.default";
    }

    @Override
    public DefaultPermissionLevel getPermissionLevel() {
        return DefaultPermissionLevel.OP;
    }

    @Override
    public String getPermissionDescription() {
        return "Permission to saves/loads the current quest database to/from the global default directory";
    }
}

