/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.longs;

import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.SafeMath;
import it.unimi.dsi.fastutil.floats.AbstractFloatCollection;
import it.unimi.dsi.fastutil.floats.FloatCollection;
import it.unimi.dsi.fastutil.floats.FloatIterator;
import it.unimi.dsi.fastutil.floats.FloatListIterator;
import it.unimi.dsi.fastutil.longs.AbstractLong2FloatMap;
import it.unimi.dsi.fastutil.longs.AbstractLong2FloatSortedMap;
import it.unimi.dsi.fastutil.longs.AbstractLongSortedSet;
import it.unimi.dsi.fastutil.longs.Long2FloatMap;
import it.unimi.dsi.fastutil.longs.Long2FloatSortedMap;
import it.unimi.dsi.fastutil.longs.LongComparator;
import it.unimi.dsi.fastutil.longs.LongListIterator;
import it.unimi.dsi.fastutil.longs.LongSortedSet;
import it.unimi.dsi.fastutil.objects.AbstractObjectSortedSet;
import it.unimi.dsi.fastutil.objects.ObjectBidirectionalIterator;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import it.unimi.dsi.fastutil.objects.ObjectSortedSet;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.LongConsumer;
import java.util.function.LongFunction;
import java.util.function.LongToDoubleFunction;

public class Long2FloatLinkedOpenHashMap
extends AbstractLong2FloatSortedMap
implements Serializable,
Cloneable,
Hash {
    private static final long serialVersionUID = 0L;
    private static final boolean ASSERTS = false;
    protected transient long[] key;
    protected transient float[] value;
    protected transient int mask;
    protected transient boolean containsNullKey;
    protected transient int first = -1;
    protected transient int last = -1;
    protected transient long[] link;
    protected transient int n;
    protected transient int maxFill;
    protected final transient int minN;
    protected int size;
    protected final float f;
    protected transient Long2FloatSortedMap.FastSortedEntrySet entries;
    protected transient LongSortedSet keys;
    protected transient FloatCollection values;

    public Long2FloatLinkedOpenHashMap(int expected, float f) {
        if (f <= 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and smaller than or equal to 1");
        }
        if (expected < 0) {
            throw new IllegalArgumentException("The expected number of elements must be nonnegative");
        }
        this.f = f;
        this.minN = this.n = HashCommon.arraySize(expected, f);
        this.mask = this.n - 1;
        this.maxFill = HashCommon.maxFill(this.n, f);
        this.key = new long[this.n + 1];
        this.value = new float[this.n + 1];
        this.link = new long[this.n + 1];
    }

    public Long2FloatLinkedOpenHashMap(int expected) {
        this(expected, 0.75f);
    }

    public Long2FloatLinkedOpenHashMap() {
        this(16, 0.75f);
    }

    public Long2FloatLinkedOpenHashMap(Map<? extends Long, ? extends Float> m, float f) {
        this(m.size(), f);
        this.putAll(m);
    }

    public Long2FloatLinkedOpenHashMap(Map<? extends Long, ? extends Float> m) {
        this(m, 0.75f);
    }

    public Long2FloatLinkedOpenHashMap(Long2FloatMap m, float f) {
        this(m.size(), f);
        this.putAll(m);
    }

    public Long2FloatLinkedOpenHashMap(Long2FloatMap m) {
        this(m, 0.75f);
    }

    public Long2FloatLinkedOpenHashMap(long[] k, float[] v, float f) {
        this(k.length, f);
        if (k.length != v.length) {
            throw new IllegalArgumentException("The key array and the value array have different lengths (" + k.length + " and " + v.length + ")");
        }
        for (int i = 0; i < k.length; ++i) {
            this.put(k[i], v[i]);
        }
    }

    public Long2FloatLinkedOpenHashMap(long[] k, float[] v) {
        this(k, v, 0.75f);
    }

    private int realSize() {
        return this.containsNullKey ? this.size - 1 : this.size;
    }

    private void ensureCapacity(int capacity) {
        int needed = HashCommon.arraySize(capacity, this.f);
        if (needed > this.n) {
            this.rehash(needed);
        }
    }

    private void tryCapacity(long capacity) {
        int needed = (int)Math.min(0x40000000L, Math.max(2L, HashCommon.nextPowerOfTwo((long)Math.ceil((float)capacity / this.f))));
        if (needed > this.n) {
            this.rehash(needed);
        }
    }

    private float removeEntry(int pos2) {
        float oldValue = this.value[pos2];
        --this.size;
        this.fixPointers(pos2);
        this.shiftKeys(pos2);
        if (this.n > this.minN && this.size < this.maxFill / 4 && this.n > 16) {
            this.rehash(this.n / 2);
        }
        return oldValue;
    }

    private float removeNullEntry() {
        this.containsNullKey = false;
        float oldValue = this.value[this.n];
        --this.size;
        this.fixPointers(this.n);
        if (this.n > this.minN && this.size < this.maxFill / 4 && this.n > 16) {
            this.rehash(this.n / 2);
        }
        return oldValue;
    }

    @Override
    public void putAll(Map<? extends Long, ? extends Float> m) {
        if ((double)this.f <= 0.5) {
            this.ensureCapacity(m.size());
        } else {
            this.tryCapacity(this.size() + m.size());
        }
        super.putAll(m);
    }

    private int find(long k) {
        if (k == 0L) {
            return this.containsNullKey ? this.n : -(this.n + 1);
        }
        long[] key = this.key;
        int pos2 = (int)HashCommon.mix(k) & this.mask;
        long curr = key[pos2];
        if (curr == 0L) {
            return -(pos2 + 1);
        }
        if (k == curr) {
            return pos2;
        }
        do {
            if ((curr = key[pos2 = pos2 + 1 & this.mask]) != 0L) continue;
            return -(pos2 + 1);
        } while (k != curr);
        return pos2;
    }

    private void insert(int pos2, long k, float v) {
        if (pos2 == this.n) {
            this.containsNullKey = true;
        }
        this.key[pos2] = k;
        this.value[pos2] = v;
        if (this.size == 0) {
            this.first = this.last = pos2;
            this.link[pos2] = -1L;
        } else {
            int n = this.last;
            this.link[n] = this.link[n] ^ (this.link[this.last] ^ (long)pos2 & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            this.link[pos2] = ((long)this.last & 0xFFFFFFFFL) << 32 | 0xFFFFFFFFL;
            this.last = pos2;
        }
        if (this.size++ >= this.maxFill) {
            this.rehash(HashCommon.arraySize(this.size + 1, this.f));
        }
    }

    @Override
    public float put(long k, float v) {
        int pos2 = this.find(k);
        if (pos2 < 0) {
            this.insert(-pos2 - 1, k, v);
            return this.defRetValue;
        }
        float oldValue = this.value[pos2];
        this.value[pos2] = v;
        return oldValue;
    }

    private float addToValue(int pos2, float incr) {
        float oldValue = this.value[pos2];
        this.value[pos2] = oldValue + incr;
        return oldValue;
    }

    public float addTo(long k, float incr) {
        int pos2;
        if (k == 0L) {
            if (this.containsNullKey) {
                return this.addToValue(this.n, incr);
            }
            pos2 = this.n;
            this.containsNullKey = true;
        } else {
            long[] key = this.key;
            pos2 = (int)HashCommon.mix(k) & this.mask;
            long curr = key[pos2];
            if (curr != 0L) {
                if (curr == k) {
                    return this.addToValue(pos2, incr);
                }
                while ((curr = key[pos2 = pos2 + 1 & this.mask]) != 0L) {
                    if (curr != k) continue;
                    return this.addToValue(pos2, incr);
                }
            }
        }
        this.key[pos2] = k;
        this.value[pos2] = this.defRetValue + incr;
        if (this.size == 0) {
            this.first = this.last = pos2;
            this.link[pos2] = -1L;
        } else {
            int n = this.last;
            this.link[n] = this.link[n] ^ (this.link[this.last] ^ (long)pos2 & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            this.link[pos2] = ((long)this.last & 0xFFFFFFFFL) << 32 | 0xFFFFFFFFL;
            this.last = pos2;
        }
        if (this.size++ >= this.maxFill) {
            this.rehash(HashCommon.arraySize(this.size + 1, this.f));
        }
        return this.defRetValue;
    }

    protected final void shiftKeys(int pos2) {
        long[] key = this.key;
        while (true) {
            long curr;
            int last = pos2;
            pos2 = last + 1 & this.mask;
            while (true) {
                if ((curr = key[pos2]) == 0L) {
                    key[last] = 0L;
                    return;
                }
                int slot = (int)HashCommon.mix(curr) & this.mask;
                if (last <= pos2 ? last >= slot || slot > pos2 : last >= slot && slot > pos2) break;
                pos2 = pos2 + 1 & this.mask;
            }
            key[last] = curr;
            this.value[last] = this.value[pos2];
            this.fixPointers(pos2, last);
        }
    }

    @Override
    public float remove(long k) {
        if (k == 0L) {
            if (this.containsNullKey) {
                return this.removeNullEntry();
            }
            return this.defRetValue;
        }
        long[] key = this.key;
        int pos2 = (int)HashCommon.mix(k) & this.mask;
        long curr = key[pos2];
        if (curr == 0L) {
            return this.defRetValue;
        }
        if (k == curr) {
            return this.removeEntry(pos2);
        }
        do {
            if ((curr = key[pos2 = pos2 + 1 & this.mask]) != 0L) continue;
            return this.defRetValue;
        } while (k != curr);
        return this.removeEntry(pos2);
    }

    private float setValue(int pos2, float v) {
        float oldValue = this.value[pos2];
        this.value[pos2] = v;
        return oldValue;
    }

    public float removeFirstFloat() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        int pos2 = this.first;
        this.first = (int)this.link[pos2];
        if (0 <= this.first) {
            int n = this.first;
            this.link[n] = this.link[n] | 0xFFFFFFFF00000000L;
        }
        --this.size;
        float v = this.value[pos2];
        if (pos2 == this.n) {
            this.containsNullKey = false;
        } else {
            this.shiftKeys(pos2);
        }
        if (this.n > this.minN && this.size < this.maxFill / 4 && this.n > 16) {
            this.rehash(this.n / 2);
        }
        return v;
    }

    public float removeLastFloat() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        int pos2 = this.last;
        this.last = (int)(this.link[pos2] >>> 32);
        if (0 <= this.last) {
            int n = this.last;
            this.link[n] = this.link[n] | 0xFFFFFFFFL;
        }
        --this.size;
        float v = this.value[pos2];
        if (pos2 == this.n) {
            this.containsNullKey = false;
        } else {
            this.shiftKeys(pos2);
        }
        if (this.n > this.minN && this.size < this.maxFill / 4 && this.n > 16) {
            this.rehash(this.n / 2);
        }
        return v;
    }

    private void moveIndexToFirst(int i) {
        if (this.size == 1 || this.first == i) {
            return;
        }
        if (this.last == i) {
            int n = this.last = (int)(this.link[i] >>> 32);
            this.link[n] = this.link[n] | 0xFFFFFFFFL;
        } else {
            long linki = this.link[i];
            int prev = (int)(linki >>> 32);
            int next = (int)linki;
            int n = prev;
            this.link[n] = this.link[n] ^ (this.link[prev] ^ linki & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            int n2 = next;
            this.link[n2] = this.link[n2] ^ (this.link[next] ^ linki & 0xFFFFFFFF00000000L) & 0xFFFFFFFF00000000L;
        }
        int n = this.first;
        this.link[n] = this.link[n] ^ (this.link[this.first] ^ ((long)i & 0xFFFFFFFFL) << 32) & 0xFFFFFFFF00000000L;
        this.link[i] = 0xFFFFFFFF00000000L | (long)this.first & 0xFFFFFFFFL;
        this.first = i;
    }

    private void moveIndexToLast(int i) {
        if (this.size == 1 || this.last == i) {
            return;
        }
        if (this.first == i) {
            int n = this.first = (int)this.link[i];
            this.link[n] = this.link[n] | 0xFFFFFFFF00000000L;
        } else {
            long linki = this.link[i];
            int prev = (int)(linki >>> 32);
            int next = (int)linki;
            int n = prev;
            this.link[n] = this.link[n] ^ (this.link[prev] ^ linki & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            int n2 = next;
            this.link[n2] = this.link[n2] ^ (this.link[next] ^ linki & 0xFFFFFFFF00000000L) & 0xFFFFFFFF00000000L;
        }
        int n = this.last;
        this.link[n] = this.link[n] ^ (this.link[this.last] ^ (long)i & 0xFFFFFFFFL) & 0xFFFFFFFFL;
        this.link[i] = ((long)this.last & 0xFFFFFFFFL) << 32 | 0xFFFFFFFFL;
        this.last = i;
    }

    public float getAndMoveToFirst(long k) {
        if (k == 0L) {
            if (this.containsNullKey) {
                this.moveIndexToFirst(this.n);
                return this.value[this.n];
            }
            return this.defRetValue;
        }
        long[] key = this.key;
        int pos2 = (int)HashCommon.mix(k) & this.mask;
        long curr = key[pos2];
        if (curr == 0L) {
            return this.defRetValue;
        }
        if (k == curr) {
            this.moveIndexToFirst(pos2);
            return this.value[pos2];
        }
        do {
            if ((curr = key[pos2 = pos2 + 1 & this.mask]) != 0L) continue;
            return this.defRetValue;
        } while (k != curr);
        this.moveIndexToFirst(pos2);
        return this.value[pos2];
    }

    public float getAndMoveToLast(long k) {
        if (k == 0L) {
            if (this.containsNullKey) {
                this.moveIndexToLast(this.n);
                return this.value[this.n];
            }
            return this.defRetValue;
        }
        long[] key = this.key;
        int pos2 = (int)HashCommon.mix(k) & this.mask;
        long curr = key[pos2];
        if (curr == 0L) {
            return this.defRetValue;
        }
        if (k == curr) {
            this.moveIndexToLast(pos2);
            return this.value[pos2];
        }
        do {
            if ((curr = key[pos2 = pos2 + 1 & this.mask]) != 0L) continue;
            return this.defRetValue;
        } while (k != curr);
        this.moveIndexToLast(pos2);
        return this.value[pos2];
    }

    public float putAndMoveToFirst(long k, float v) {
        int pos2;
        if (k == 0L) {
            if (this.containsNullKey) {
                this.moveIndexToFirst(this.n);
                return this.setValue(this.n, v);
            }
            this.containsNullKey = true;
            pos2 = this.n;
        } else {
            long[] key = this.key;
            pos2 = (int)HashCommon.mix(k) & this.mask;
            long curr = key[pos2];
            if (curr != 0L) {
                if (curr == k) {
                    this.moveIndexToFirst(pos2);
                    return this.setValue(pos2, v);
                }
                while ((curr = key[pos2 = pos2 + 1 & this.mask]) != 0L) {
                    if (curr != k) continue;
                    this.moveIndexToFirst(pos2);
                    return this.setValue(pos2, v);
                }
            }
        }
        this.key[pos2] = k;
        this.value[pos2] = v;
        if (this.size == 0) {
            this.first = this.last = pos2;
            this.link[pos2] = -1L;
        } else {
            int n = this.first;
            this.link[n] = this.link[n] ^ (this.link[this.first] ^ ((long)pos2 & 0xFFFFFFFFL) << 32) & 0xFFFFFFFF00000000L;
            this.link[pos2] = 0xFFFFFFFF00000000L | (long)this.first & 0xFFFFFFFFL;
            this.first = pos2;
        }
        if (this.size++ >= this.maxFill) {
            this.rehash(HashCommon.arraySize(this.size, this.f));
        }
        return this.defRetValue;
    }

    public float putAndMoveToLast(long k, float v) {
        int pos2;
        if (k == 0L) {
            if (this.containsNullKey) {
                this.moveIndexToLast(this.n);
                return this.setValue(this.n, v);
            }
            this.containsNullKey = true;
            pos2 = this.n;
        } else {
            long[] key = this.key;
            pos2 = (int)HashCommon.mix(k) & this.mask;
            long curr = key[pos2];
            if (curr != 0L) {
                if (curr == k) {
                    this.moveIndexToLast(pos2);
                    return this.setValue(pos2, v);
                }
                while ((curr = key[pos2 = pos2 + 1 & this.mask]) != 0L) {
                    if (curr != k) continue;
                    this.moveIndexToLast(pos2);
                    return this.setValue(pos2, v);
                }
            }
        }
        this.key[pos2] = k;
        this.value[pos2] = v;
        if (this.size == 0) {
            this.first = this.last = pos2;
            this.link[pos2] = -1L;
        } else {
            int n = this.last;
            this.link[n] = this.link[n] ^ (this.link[this.last] ^ (long)pos2 & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            this.link[pos2] = ((long)this.last & 0xFFFFFFFFL) << 32 | 0xFFFFFFFFL;
            this.last = pos2;
        }
        if (this.size++ >= this.maxFill) {
            this.rehash(HashCommon.arraySize(this.size, this.f));
        }
        return this.defRetValue;
    }

    @Override
    public float get(long k) {
        if (k == 0L) {
            return this.containsNullKey ? this.value[this.n] : this.defRetValue;
        }
        long[] key = this.key;
        int pos2 = (int)HashCommon.mix(k) & this.mask;
        long curr = key[pos2];
        if (curr == 0L) {
            return this.defRetValue;
        }
        if (k == curr) {
            return this.value[pos2];
        }
        do {
            if ((curr = key[pos2 = pos2 + 1 & this.mask]) != 0L) continue;
            return this.defRetValue;
        } while (k != curr);
        return this.value[pos2];
    }

    @Override
    public boolean containsKey(long k) {
        if (k == 0L) {
            return this.containsNullKey;
        }
        long[] key = this.key;
        int pos2 = (int)HashCommon.mix(k) & this.mask;
        long curr = key[pos2];
        if (curr == 0L) {
            return false;
        }
        if (k == curr) {
            return true;
        }
        do {
            if ((curr = key[pos2 = pos2 + 1 & this.mask]) != 0L) continue;
            return false;
        } while (k != curr);
        return true;
    }

    @Override
    public boolean containsValue(float v) {
        float[] value = this.value;
        long[] key = this.key;
        if (this.containsNullKey && Float.floatToIntBits(value[this.n]) == Float.floatToIntBits(v)) {
            return true;
        }
        int i = this.n;
        while (i-- != 0) {
            if (key[i] == 0L || Float.floatToIntBits(value[i]) != Float.floatToIntBits(v)) continue;
            return true;
        }
        return false;
    }

    @Override
    public float getOrDefault(long k, float defaultValue) {
        if (k == 0L) {
            return this.containsNullKey ? this.value[this.n] : defaultValue;
        }
        long[] key = this.key;
        int pos2 = (int)HashCommon.mix(k) & this.mask;
        long curr = key[pos2];
        if (curr == 0L) {
            return defaultValue;
        }
        if (k == curr) {
            return this.value[pos2];
        }
        do {
            if ((curr = key[pos2 = pos2 + 1 & this.mask]) != 0L) continue;
            return defaultValue;
        } while (k != curr);
        return this.value[pos2];
    }

    @Override
    public float putIfAbsent(long k, float v) {
        int pos2 = this.find(k);
        if (pos2 >= 0) {
            return this.value[pos2];
        }
        this.insert(-pos2 - 1, k, v);
        return this.defRetValue;
    }

    @Override
    public boolean remove(long k, float v) {
        if (k == 0L) {
            if (this.containsNullKey && Float.floatToIntBits(v) == Float.floatToIntBits(this.value[this.n])) {
                this.removeNullEntry();
                return true;
            }
            return false;
        }
        long[] key = this.key;
        int pos2 = (int)HashCommon.mix(k) & this.mask;
        long curr = key[pos2];
        if (curr == 0L) {
            return false;
        }
        if (k == curr && Float.floatToIntBits(v) == Float.floatToIntBits(this.value[pos2])) {
            this.removeEntry(pos2);
            return true;
        }
        do {
            if ((curr = key[pos2 = pos2 + 1 & this.mask]) != 0L) continue;
            return false;
        } while (k != curr || Float.floatToIntBits(v) != Float.floatToIntBits(this.value[pos2]));
        this.removeEntry(pos2);
        return true;
    }

    @Override
    public boolean replace(long k, float oldValue, float v) {
        int pos2 = this.find(k);
        if (pos2 < 0 || Float.floatToIntBits(oldValue) != Float.floatToIntBits(this.value[pos2])) {
            return false;
        }
        this.value[pos2] = v;
        return true;
    }

    @Override
    public float replace(long k, float v) {
        int pos2 = this.find(k);
        if (pos2 < 0) {
            return this.defRetValue;
        }
        float oldValue = this.value[pos2];
        this.value[pos2] = v;
        return oldValue;
    }

    @Override
    public float computeIfAbsent(long k, LongToDoubleFunction mappingFunction) {
        Objects.requireNonNull(mappingFunction);
        int pos2 = this.find(k);
        if (pos2 >= 0) {
            return this.value[pos2];
        }
        float newValue = SafeMath.safeDoubleToFloat(mappingFunction.applyAsDouble(k));
        this.insert(-pos2 - 1, k, newValue);
        return newValue;
    }

    @Override
    public float computeIfAbsentNullable(long k, LongFunction<? extends Float> mappingFunction) {
        Objects.requireNonNull(mappingFunction);
        int pos2 = this.find(k);
        if (pos2 >= 0) {
            return this.value[pos2];
        }
        Float newValue = mappingFunction.apply(k);
        if (newValue == null) {
            return this.defRetValue;
        }
        float v = newValue.floatValue();
        this.insert(-pos2 - 1, k, v);
        return v;
    }

    @Override
    public float computeIfPresent(long k, BiFunction<? super Long, ? super Float, ? extends Float> remappingFunction) {
        Objects.requireNonNull(remappingFunction);
        int pos2 = this.find(k);
        if (pos2 < 0) {
            return this.defRetValue;
        }
        Float newValue = remappingFunction.apply((Long)k, Float.valueOf(this.value[pos2]));
        if (newValue == null) {
            if (k == 0L) {
                this.removeNullEntry();
            } else {
                this.removeEntry(pos2);
            }
            return this.defRetValue;
        }
        this.value[pos2] = newValue.floatValue();
        return this.value[pos2];
    }

    @Override
    public float compute(long k, BiFunction<? super Long, ? super Float, ? extends Float> remappingFunction) {
        Objects.requireNonNull(remappingFunction);
        int pos2 = this.find(k);
        Float newValue = remappingFunction.apply((Long)k, pos2 >= 0 ? Float.valueOf(this.value[pos2]) : null);
        if (newValue == null) {
            if (pos2 >= 0) {
                if (k == 0L) {
                    this.removeNullEntry();
                } else {
                    this.removeEntry(pos2);
                }
            }
            return this.defRetValue;
        }
        float newVal = newValue.floatValue();
        if (pos2 < 0) {
            this.insert(-pos2 - 1, k, newVal);
            return newVal;
        }
        this.value[pos2] = newVal;
        return this.value[pos2];
    }

    @Override
    public float merge(long k, float v, BiFunction<? super Float, ? super Float, ? extends Float> remappingFunction) {
        Objects.requireNonNull(remappingFunction);
        int pos2 = this.find(k);
        if (pos2 < 0) {
            this.insert(-pos2 - 1, k, v);
            return v;
        }
        Float newValue = remappingFunction.apply(Float.valueOf(this.value[pos2]), Float.valueOf(v));
        if (newValue == null) {
            if (k == 0L) {
                this.removeNullEntry();
            } else {
                this.removeEntry(pos2);
            }
            return this.defRetValue;
        }
        this.value[pos2] = newValue.floatValue();
        return this.value[pos2];
    }

    @Override
    public void clear() {
        if (this.size == 0) {
            return;
        }
        this.size = 0;
        this.containsNullKey = false;
        Arrays.fill(this.key, 0L);
        this.last = -1;
        this.first = -1;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    protected void fixPointers(int i) {
        if (this.size == 0) {
            this.last = -1;
            this.first = -1;
            return;
        }
        if (this.first == i) {
            this.first = (int)this.link[i];
            if (0 <= this.first) {
                int n = this.first;
                this.link[n] = this.link[n] | 0xFFFFFFFF00000000L;
            }
            return;
        }
        if (this.last == i) {
            this.last = (int)(this.link[i] >>> 32);
            if (0 <= this.last) {
                int n = this.last;
                this.link[n] = this.link[n] | 0xFFFFFFFFL;
            }
            return;
        }
        long linki = this.link[i];
        int prev = (int)(linki >>> 32);
        int next = (int)linki;
        int n = prev;
        this.link[n] = this.link[n] ^ (this.link[prev] ^ linki & 0xFFFFFFFFL) & 0xFFFFFFFFL;
        int n2 = next;
        this.link[n2] = this.link[n2] ^ (this.link[next] ^ linki & 0xFFFFFFFF00000000L) & 0xFFFFFFFF00000000L;
    }

    protected void fixPointers(int s, int d) {
        if (this.size == 1) {
            this.first = this.last = d;
            this.link[d] = -1L;
            return;
        }
        if (this.first == s) {
            this.first = d;
            int n = (int)this.link[s];
            this.link[n] = this.link[n] ^ (this.link[(int)this.link[s]] ^ ((long)d & 0xFFFFFFFFL) << 32) & 0xFFFFFFFF00000000L;
            this.link[d] = this.link[s];
            return;
        }
        if (this.last == s) {
            this.last = d;
            int n = (int)(this.link[s] >>> 32);
            this.link[n] = this.link[n] ^ (this.link[(int)(this.link[s] >>> 32)] ^ (long)d & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            this.link[d] = this.link[s];
            return;
        }
        long links = this.link[s];
        int prev = (int)(links >>> 32);
        int next = (int)links;
        int n = prev;
        this.link[n] = this.link[n] ^ (this.link[prev] ^ (long)d & 0xFFFFFFFFL) & 0xFFFFFFFFL;
        int n2 = next;
        this.link[n2] = this.link[n2] ^ (this.link[next] ^ ((long)d & 0xFFFFFFFFL) << 32) & 0xFFFFFFFF00000000L;
        this.link[d] = links;
    }

    @Override
    public long firstLongKey() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.key[this.first];
    }

    @Override
    public long lastLongKey() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.key[this.last];
    }

    @Override
    public Long2FloatSortedMap tailMap(long from) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Long2FloatSortedMap headMap(long to) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Long2FloatSortedMap subMap(long from, long to) {
        throw new UnsupportedOperationException();
    }

    @Override
    public LongComparator comparator() {
        return null;
    }

    @Override
    public Long2FloatSortedMap.FastSortedEntrySet long2FloatEntrySet() {
        if (this.entries == null) {
            this.entries = new MapEntrySet();
        }
        return this.entries;
    }

    @Override
    public LongSortedSet keySet() {
        if (this.keys == null) {
            this.keys = new KeySet();
        }
        return this.keys;
    }

    @Override
    public FloatCollection values() {
        if (this.values == null) {
            this.values = new AbstractFloatCollection(){

                @Override
                public FloatIterator iterator() {
                    return new ValueIterator();
                }

                @Override
                public int size() {
                    return Long2FloatLinkedOpenHashMap.this.size;
                }

                @Override
                public boolean contains(float v) {
                    return Long2FloatLinkedOpenHashMap.this.containsValue(v);
                }

                @Override
                public void clear() {
                    Long2FloatLinkedOpenHashMap.this.clear();
                }

                @Override
                public void forEach(DoubleConsumer consumer) {
                    if (Long2FloatLinkedOpenHashMap.this.containsNullKey) {
                        consumer.accept(Long2FloatLinkedOpenHashMap.this.value[Long2FloatLinkedOpenHashMap.this.n]);
                    }
                    int pos2 = Long2FloatLinkedOpenHashMap.this.n;
                    while (pos2-- != 0) {
                        if (Long2FloatLinkedOpenHashMap.this.key[pos2] == 0L) continue;
                        consumer.accept(Long2FloatLinkedOpenHashMap.this.value[pos2]);
                    }
                }
            };
        }
        return this.values;
    }

    public boolean trim() {
        int l = HashCommon.arraySize(this.size, this.f);
        if (l >= this.n || this.size > HashCommon.maxFill(l, this.f)) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    public boolean trim(int n) {
        int l = HashCommon.nextPowerOfTwo((int)Math.ceil((float)n / this.f));
        if (l >= n || this.size > HashCommon.maxFill(l, this.f)) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    protected void rehash(int newN) {
        long[] key = this.key;
        float[] value = this.value;
        int mask = newN - 1;
        long[] newKey = new long[newN + 1];
        float[] newValue = new float[newN + 1];
        int i = this.first;
        int prev = -1;
        int newPrev = -1;
        long[] link = this.link;
        long[] newLink = new long[newN + 1];
        this.first = -1;
        int j = this.size;
        while (j-- != 0) {
            int pos2;
            if (key[i] == 0L) {
                pos2 = newN;
            } else {
                pos2 = (int)HashCommon.mix(key[i]) & mask;
                while (newKey[pos2] != 0L) {
                    pos2 = pos2 + 1 & mask;
                }
            }
            newKey[pos2] = key[i];
            newValue[pos2] = value[i];
            if (prev != -1) {
                int n = newPrev;
                newLink[n] = newLink[n] ^ (newLink[newPrev] ^ (long)pos2 & 0xFFFFFFFFL) & 0xFFFFFFFFL;
                int n2 = pos2;
                newLink[n2] = newLink[n2] ^ (newLink[pos2] ^ ((long)newPrev & 0xFFFFFFFFL) << 32) & 0xFFFFFFFF00000000L;
                newPrev = pos2;
            } else {
                newPrev = this.first = pos2;
                newLink[pos2] = -1L;
            }
            int t = i;
            i = (int)link[i];
            prev = t;
        }
        this.link = newLink;
        this.last = newPrev;
        if (newPrev != -1) {
            int n = newPrev;
            newLink[n] = newLink[n] | 0xFFFFFFFFL;
        }
        this.n = newN;
        this.mask = mask;
        this.maxFill = HashCommon.maxFill(this.n, this.f);
        this.key = newKey;
        this.value = newValue;
    }

    public Long2FloatLinkedOpenHashMap clone() {
        Long2FloatLinkedOpenHashMap c;
        try {
            c = (Long2FloatLinkedOpenHashMap)super.clone();
        }
        catch (CloneNotSupportedException cantHappen) {
            throw new InternalError();
        }
        c.keys = null;
        c.values = null;
        c.entries = null;
        c.containsNullKey = this.containsNullKey;
        c.key = (long[])this.key.clone();
        c.value = (float[])this.value.clone();
        c.link = (long[])this.link.clone();
        return c;
    }

    @Override
    public int hashCode() {
        int h = 0;
        int j = this.realSize();
        int i = 0;
        int t = 0;
        while (j-- != 0) {
            while (this.key[i] == 0L) {
                ++i;
            }
            t = HashCommon.long2int(this.key[i]);
            h += (t ^= HashCommon.float2int(this.value[i]));
            ++i;
        }
        if (this.containsNullKey) {
            h += HashCommon.float2int(this.value[this.n]);
        }
        return h;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        long[] key = this.key;
        float[] value = this.value;
        MapIterator i = new MapIterator();
        s.defaultWriteObject();
        int j = this.size;
        while (j-- != 0) {
            int e = i.nextEntry();
            s.writeLong(key[e]);
            s.writeFloat(value[e]);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.n = HashCommon.arraySize(this.size, this.f);
        this.maxFill = HashCommon.maxFill(this.n, this.f);
        this.mask = this.n - 1;
        this.key = new long[this.n + 1];
        long[] key = this.key;
        this.value = new float[this.n + 1];
        float[] value = this.value;
        this.link = new long[this.n + 1];
        long[] link = this.link;
        int prev = -1;
        this.last = -1;
        this.first = -1;
        int i = this.size;
        while (i-- != 0) {
            int pos2;
            long k = s.readLong();
            float v = s.readFloat();
            if (k == 0L) {
                pos2 = this.n;
                this.containsNullKey = true;
            } else {
                pos2 = (int)HashCommon.mix(k) & this.mask;
                while (key[pos2] != 0L) {
                    pos2 = pos2 + 1 & this.mask;
                }
            }
            key[pos2] = k;
            value[pos2] = v;
            if (this.first != -1) {
                int n = prev;
                link[n] = link[n] ^ (link[prev] ^ (long)pos2 & 0xFFFFFFFFL) & 0xFFFFFFFFL;
                int n2 = pos2;
                link[n2] = link[n2] ^ (link[pos2] ^ ((long)prev & 0xFFFFFFFFL) << 32) & 0xFFFFFFFF00000000L;
                prev = pos2;
                continue;
            }
            prev = this.first = pos2;
            int n = pos2;
            link[n] = link[n] | 0xFFFFFFFF00000000L;
        }
        this.last = prev;
        if (prev != -1) {
            int n = prev;
            link[n] = link[n] | 0xFFFFFFFFL;
        }
    }

    private void checkTable() {
    }

    private final class ValueIterator
    extends MapIterator
    implements FloatListIterator {
        @Override
        public float previousFloat() {
            return Long2FloatLinkedOpenHashMap.this.value[this.previousEntry()];
        }

        @Override
        public float nextFloat() {
            return Long2FloatLinkedOpenHashMap.this.value[this.nextEntry()];
        }
    }

    private final class KeySet
    extends AbstractLongSortedSet {
        private KeySet() {
        }

        @Override
        public LongListIterator iterator(long from) {
            return new KeyIterator(from);
        }

        @Override
        public LongListIterator iterator() {
            return new KeyIterator();
        }

        @Override
        public void forEach(LongConsumer consumer) {
            if (Long2FloatLinkedOpenHashMap.this.containsNullKey) {
                consumer.accept(Long2FloatLinkedOpenHashMap.this.key[Long2FloatLinkedOpenHashMap.this.n]);
            }
            int pos2 = Long2FloatLinkedOpenHashMap.this.n;
            while (pos2-- != 0) {
                long k = Long2FloatLinkedOpenHashMap.this.key[pos2];
                if (k == 0L) continue;
                consumer.accept(k);
            }
        }

        @Override
        public int size() {
            return Long2FloatLinkedOpenHashMap.this.size;
        }

        @Override
        public boolean contains(long k) {
            return Long2FloatLinkedOpenHashMap.this.containsKey(k);
        }

        @Override
        public boolean remove(long k) {
            int oldSize = Long2FloatLinkedOpenHashMap.this.size;
            Long2FloatLinkedOpenHashMap.this.remove(k);
            return Long2FloatLinkedOpenHashMap.this.size != oldSize;
        }

        @Override
        public void clear() {
            Long2FloatLinkedOpenHashMap.this.clear();
        }

        @Override
        public long firstLong() {
            if (Long2FloatLinkedOpenHashMap.this.size == 0) {
                throw new NoSuchElementException();
            }
            return Long2FloatLinkedOpenHashMap.this.key[Long2FloatLinkedOpenHashMap.this.first];
        }

        @Override
        public long lastLong() {
            if (Long2FloatLinkedOpenHashMap.this.size == 0) {
                throw new NoSuchElementException();
            }
            return Long2FloatLinkedOpenHashMap.this.key[Long2FloatLinkedOpenHashMap.this.last];
        }

        @Override
        public LongComparator comparator() {
            return null;
        }

        @Override
        public LongSortedSet tailSet(long from) {
            throw new UnsupportedOperationException();
        }

        @Override
        public LongSortedSet headSet(long to) {
            throw new UnsupportedOperationException();
        }

        @Override
        public LongSortedSet subSet(long from, long to) {
            throw new UnsupportedOperationException();
        }
    }

    private final class KeyIterator
    extends MapIterator
    implements LongListIterator {
        public KeyIterator(long k) {
            super(k);
        }

        @Override
        public long previousLong() {
            return Long2FloatLinkedOpenHashMap.this.key[this.previousEntry()];
        }

        public KeyIterator() {
        }

        @Override
        public long nextLong() {
            return Long2FloatLinkedOpenHashMap.this.key[this.nextEntry()];
        }
    }

    private final class MapEntrySet
    extends AbstractObjectSortedSet<Long2FloatMap.Entry>
    implements Long2FloatSortedMap.FastSortedEntrySet {
        private MapEntrySet() {
        }

        @Override
        public ObjectBidirectionalIterator<Long2FloatMap.Entry> iterator() {
            return new EntryIterator();
        }

        @Override
        public Comparator<? super Long2FloatMap.Entry> comparator() {
            return null;
        }

        @Override
        public ObjectSortedSet<Long2FloatMap.Entry> subSet(Long2FloatMap.Entry fromElement, Long2FloatMap.Entry toElement) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ObjectSortedSet<Long2FloatMap.Entry> headSet(Long2FloatMap.Entry toElement) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ObjectSortedSet<Long2FloatMap.Entry> tailSet(Long2FloatMap.Entry fromElement) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Long2FloatMap.Entry first() {
            if (Long2FloatLinkedOpenHashMap.this.size == 0) {
                throw new NoSuchElementException();
            }
            return new MapEntry(Long2FloatLinkedOpenHashMap.this.first);
        }

        @Override
        public Long2FloatMap.Entry last() {
            if (Long2FloatLinkedOpenHashMap.this.size == 0) {
                throw new NoSuchElementException();
            }
            return new MapEntry(Long2FloatLinkedOpenHashMap.this.last);
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            if (e.getKey() == null || !(e.getKey() instanceof Long)) {
                return false;
            }
            if (e.getValue() == null || !(e.getValue() instanceof Float)) {
                return false;
            }
            long k = (Long)e.getKey();
            float v = ((Float)e.getValue()).floatValue();
            if (k == 0L) {
                return Long2FloatLinkedOpenHashMap.this.containsNullKey && Float.floatToIntBits(Long2FloatLinkedOpenHashMap.this.value[Long2FloatLinkedOpenHashMap.this.n]) == Float.floatToIntBits(v);
            }
            long[] key = Long2FloatLinkedOpenHashMap.this.key;
            int pos2 = (int)HashCommon.mix(k) & Long2FloatLinkedOpenHashMap.this.mask;
            long curr = key[pos2];
            if (curr == 0L) {
                return false;
            }
            if (k == curr) {
                return Float.floatToIntBits(Long2FloatLinkedOpenHashMap.this.value[pos2]) == Float.floatToIntBits(v);
            }
            do {
                if ((curr = key[pos2 = pos2 + 1 & Long2FloatLinkedOpenHashMap.this.mask]) != 0L) continue;
                return false;
            } while (k != curr);
            return Float.floatToIntBits(Long2FloatLinkedOpenHashMap.this.value[pos2]) == Float.floatToIntBits(v);
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            if (e.getKey() == null || !(e.getKey() instanceof Long)) {
                return false;
            }
            if (e.getValue() == null || !(e.getValue() instanceof Float)) {
                return false;
            }
            long k = (Long)e.getKey();
            float v = ((Float)e.getValue()).floatValue();
            if (k == 0L) {
                if (Long2FloatLinkedOpenHashMap.this.containsNullKey && Float.floatToIntBits(Long2FloatLinkedOpenHashMap.this.value[Long2FloatLinkedOpenHashMap.this.n]) == Float.floatToIntBits(v)) {
                    Long2FloatLinkedOpenHashMap.this.removeNullEntry();
                    return true;
                }
                return false;
            }
            long[] key = Long2FloatLinkedOpenHashMap.this.key;
            int pos2 = (int)HashCommon.mix(k) & Long2FloatLinkedOpenHashMap.this.mask;
            long curr = key[pos2];
            if (curr == 0L) {
                return false;
            }
            if (curr == k) {
                if (Float.floatToIntBits(Long2FloatLinkedOpenHashMap.this.value[pos2]) == Float.floatToIntBits(v)) {
                    Long2FloatLinkedOpenHashMap.this.removeEntry(pos2);
                    return true;
                }
                return false;
            }
            do {
                if ((curr = key[pos2 = pos2 + 1 & Long2FloatLinkedOpenHashMap.this.mask]) != 0L) continue;
                return false;
            } while (curr != k || Float.floatToIntBits(Long2FloatLinkedOpenHashMap.this.value[pos2]) != Float.floatToIntBits(v));
            Long2FloatLinkedOpenHashMap.this.removeEntry(pos2);
            return true;
        }

        @Override
        public int size() {
            return Long2FloatLinkedOpenHashMap.this.size;
        }

        @Override
        public void clear() {
            Long2FloatLinkedOpenHashMap.this.clear();
        }

        @Override
        public ObjectListIterator<Long2FloatMap.Entry> iterator(Long2FloatMap.Entry from) {
            return new EntryIterator(from.getLongKey());
        }

        @Override
        public ObjectListIterator<Long2FloatMap.Entry> fastIterator() {
            return new FastEntryIterator();
        }

        public ObjectListIterator<Long2FloatMap.Entry> fastIterator(Long2FloatMap.Entry from) {
            return new FastEntryIterator(from.getLongKey());
        }

        @Override
        public void forEach(Consumer<? super Long2FloatMap.Entry> consumer) {
            int i = Long2FloatLinkedOpenHashMap.this.size;
            int next = Long2FloatLinkedOpenHashMap.this.first;
            while (i-- != 0) {
                int curr = next;
                next = (int)Long2FloatLinkedOpenHashMap.this.link[curr];
                consumer.accept(new AbstractLong2FloatMap.BasicEntry(Long2FloatLinkedOpenHashMap.this.key[curr], Long2FloatLinkedOpenHashMap.this.value[curr]));
            }
        }

        @Override
        public void fastForEach(Consumer<? super Long2FloatMap.Entry> consumer) {
            AbstractLong2FloatMap.BasicEntry entry = new AbstractLong2FloatMap.BasicEntry();
            int i = Long2FloatLinkedOpenHashMap.this.size;
            int next = Long2FloatLinkedOpenHashMap.this.first;
            while (i-- != 0) {
                int curr = next;
                next = (int)Long2FloatLinkedOpenHashMap.this.link[curr];
                entry.key = Long2FloatLinkedOpenHashMap.this.key[curr];
                entry.value = Long2FloatLinkedOpenHashMap.this.value[curr];
                consumer.accept(entry);
            }
        }
    }

    private class FastEntryIterator
    extends MapIterator
    implements ObjectListIterator<Long2FloatMap.Entry> {
        final MapEntry entry;

        public FastEntryIterator() {
            this.entry = new MapEntry();
        }

        public FastEntryIterator(long from) {
            super(from);
            this.entry = new MapEntry();
        }

        @Override
        public MapEntry next() {
            this.entry.index = this.nextEntry();
            return this.entry;
        }

        @Override
        public MapEntry previous() {
            this.entry.index = this.previousEntry();
            return this.entry;
        }
    }

    private class EntryIterator
    extends MapIterator
    implements ObjectListIterator<Long2FloatMap.Entry> {
        private MapEntry entry;

        public EntryIterator() {
        }

        public EntryIterator(long from) {
            super(from);
        }

        @Override
        public MapEntry next() {
            this.entry = new MapEntry(this.nextEntry());
            return this.entry;
        }

        @Override
        public MapEntry previous() {
            this.entry = new MapEntry(this.previousEntry());
            return this.entry;
        }

        @Override
        public void remove() {
            super.remove();
            this.entry.index = -1;
        }
    }

    private class MapIterator {
        int prev = -1;
        int next = -1;
        int curr = -1;
        int index = -1;

        protected MapIterator() {
            this.next = Long2FloatLinkedOpenHashMap.this.first;
            this.index = 0;
        }

        private MapIterator(long from) {
            if (from == 0L) {
                if (Long2FloatLinkedOpenHashMap.this.containsNullKey) {
                    this.next = (int)Long2FloatLinkedOpenHashMap.this.link[Long2FloatLinkedOpenHashMap.this.n];
                    this.prev = Long2FloatLinkedOpenHashMap.this.n;
                    return;
                }
                throw new NoSuchElementException("The key " + from + " does not belong to this map.");
            }
            if (Long2FloatLinkedOpenHashMap.this.key[Long2FloatLinkedOpenHashMap.this.last] == from) {
                this.prev = Long2FloatLinkedOpenHashMap.this.last;
                this.index = Long2FloatLinkedOpenHashMap.this.size;
                return;
            }
            int pos2 = (int)HashCommon.mix(from) & Long2FloatLinkedOpenHashMap.this.mask;
            while (Long2FloatLinkedOpenHashMap.this.key[pos2] != 0L) {
                if (Long2FloatLinkedOpenHashMap.this.key[pos2] == from) {
                    this.next = (int)Long2FloatLinkedOpenHashMap.this.link[pos2];
                    this.prev = pos2;
                    return;
                }
                pos2 = pos2 + 1 & Long2FloatLinkedOpenHashMap.this.mask;
            }
            throw new NoSuchElementException("The key " + from + " does not belong to this map.");
        }

        public boolean hasNext() {
            return this.next != -1;
        }

        public boolean hasPrevious() {
            return this.prev != -1;
        }

        private final void ensureIndexKnown() {
            if (this.index >= 0) {
                return;
            }
            if (this.prev == -1) {
                this.index = 0;
                return;
            }
            if (this.next == -1) {
                this.index = Long2FloatLinkedOpenHashMap.this.size;
                return;
            }
            int pos2 = Long2FloatLinkedOpenHashMap.this.first;
            this.index = 1;
            while (pos2 != this.prev) {
                pos2 = (int)Long2FloatLinkedOpenHashMap.this.link[pos2];
                ++this.index;
            }
        }

        public int nextIndex() {
            this.ensureIndexKnown();
            return this.index;
        }

        public int previousIndex() {
            this.ensureIndexKnown();
            return this.index - 1;
        }

        public int nextEntry() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.curr = this.next;
            this.next = (int)Long2FloatLinkedOpenHashMap.this.link[this.curr];
            this.prev = this.curr;
            if (this.index >= 0) {
                ++this.index;
            }
            return this.curr;
        }

        public int previousEntry() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            this.curr = this.prev;
            this.prev = (int)(Long2FloatLinkedOpenHashMap.this.link[this.curr] >>> 32);
            this.next = this.curr;
            if (this.index >= 0) {
                --this.index;
            }
            return this.curr;
        }

        public void remove() {
            this.ensureIndexKnown();
            if (this.curr == -1) {
                throw new IllegalStateException();
            }
            if (this.curr == this.prev) {
                --this.index;
                this.prev = (int)(Long2FloatLinkedOpenHashMap.this.link[this.curr] >>> 32);
            } else {
                this.next = (int)Long2FloatLinkedOpenHashMap.this.link[this.curr];
            }
            --Long2FloatLinkedOpenHashMap.this.size;
            if (this.prev == -1) {
                Long2FloatLinkedOpenHashMap.this.first = this.next;
            } else {
                int n = this.prev;
                Long2FloatLinkedOpenHashMap.this.link[n] = Long2FloatLinkedOpenHashMap.this.link[n] ^ (Long2FloatLinkedOpenHashMap.this.link[this.prev] ^ (long)this.next & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            }
            if (this.next == -1) {
                Long2FloatLinkedOpenHashMap.this.last = this.prev;
            } else {
                int n = this.next;
                Long2FloatLinkedOpenHashMap.this.link[n] = Long2FloatLinkedOpenHashMap.this.link[n] ^ (Long2FloatLinkedOpenHashMap.this.link[this.next] ^ ((long)this.prev & 0xFFFFFFFFL) << 32) & 0xFFFFFFFF00000000L;
            }
            int pos2 = this.curr;
            this.curr = -1;
            if (pos2 != Long2FloatLinkedOpenHashMap.this.n) {
                long[] key = Long2FloatLinkedOpenHashMap.this.key;
                while (true) {
                    long curr;
                    int last = pos2;
                    pos2 = last + 1 & Long2FloatLinkedOpenHashMap.this.mask;
                    while (true) {
                        if ((curr = key[pos2]) == 0L) {
                            key[last] = 0L;
                            return;
                        }
                        int slot = (int)HashCommon.mix(curr) & Long2FloatLinkedOpenHashMap.this.mask;
                        if (last <= pos2 ? last >= slot || slot > pos2 : last >= slot && slot > pos2) break;
                        pos2 = pos2 + 1 & Long2FloatLinkedOpenHashMap.this.mask;
                    }
                    key[last] = curr;
                    Long2FloatLinkedOpenHashMap.this.value[last] = Long2FloatLinkedOpenHashMap.this.value[pos2];
                    if (this.next == pos2) {
                        this.next = last;
                    }
                    if (this.prev == pos2) {
                        this.prev = last;
                    }
                    Long2FloatLinkedOpenHashMap.this.fixPointers(pos2, last);
                }
            }
            Long2FloatLinkedOpenHashMap.this.containsNullKey = false;
        }

        public int skip(int n) {
            int i = n;
            while (i-- != 0 && this.hasNext()) {
                this.nextEntry();
            }
            return n - i - 1;
        }

        public int back(int n) {
            int i = n;
            while (i-- != 0 && this.hasPrevious()) {
                this.previousEntry();
            }
            return n - i - 1;
        }

        public void set(Long2FloatMap.Entry ok) {
            throw new UnsupportedOperationException();
        }

        public void add(Long2FloatMap.Entry ok) {
            throw new UnsupportedOperationException();
        }
    }

    final class MapEntry
    implements Long2FloatMap.Entry,
    Map.Entry<Long, Float> {
        int index;

        MapEntry(int index) {
            this.index = index;
        }

        MapEntry() {
        }

        @Override
        public long getLongKey() {
            return Long2FloatLinkedOpenHashMap.this.key[this.index];
        }

        @Override
        public float getFloatValue() {
            return Long2FloatLinkedOpenHashMap.this.value[this.index];
        }

        @Override
        public float setValue(float v) {
            float oldValue = Long2FloatLinkedOpenHashMap.this.value[this.index];
            Long2FloatLinkedOpenHashMap.this.value[this.index] = v;
            return oldValue;
        }

        @Override
        @Deprecated
        public Long getKey() {
            return Long2FloatLinkedOpenHashMap.this.key[this.index];
        }

        @Override
        @Deprecated
        public Float getValue() {
            return Float.valueOf(Long2FloatLinkedOpenHashMap.this.value[this.index]);
        }

        @Override
        @Deprecated
        public Float setValue(Float v) {
            return Float.valueOf(this.setValue(v.floatValue()));
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return Long2FloatLinkedOpenHashMap.this.key[this.index] == (Long)e.getKey() && Float.floatToIntBits(Long2FloatLinkedOpenHashMap.this.value[this.index]) == Float.floatToIntBits(((Float)e.getValue()).floatValue());
        }

        @Override
        public int hashCode() {
            return HashCommon.long2int(Long2FloatLinkedOpenHashMap.this.key[this.index]) ^ HashCommon.float2int(Long2FloatLinkedOpenHashMap.this.value[this.index]);
        }

        public String toString() {
            return Long2FloatLinkedOpenHashMap.this.key[this.index] + "=>" + Long2FloatLinkedOpenHashMap.this.value[this.index];
        }
    }
}

