/*
 * Decompiled with CFR 0.152.
 */
package games.thecodewarrior.bitfont.editor.mode;

import games.thecodewarrior.bitfont.editor.Editor;
import games.thecodewarrior.bitfont.editor.Modifier;
import games.thecodewarrior.bitfont.editor.mode.CursorPosition;
import games.thecodewarrior.bitfont.editor.mode.CursorRange;
import games.thecodewarrior.bitfont.editor.mode.DefaultEditorMode;
import games.thecodewarrior.bitfont.editor.mode.SimpleEditorMode;
import games.thecodewarrior.bitfont.editor.utils.Clipboard;
import games.thecodewarrior.bitfont.editor.utils.InternalClipboard;
import games.thecodewarrior.bitfont.typesetting.TypesetString;
import games.thecodewarrior.bitfont.utils.ClampKt;
import games.thecodewarrior.bitfont.utils.ExperimentalBitfont;
import games.thecodewarrior.bitfont.utils.Vec2i;
import games.thecodewarrior.bitfont.utils.extensions.BreakType;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0010\b\u0017\u0018\u0000 =2\u00020\u0001:\u0001=B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\"\u001a\u00020#H\u0004J\b\u0010$\u001a\u00020#H\u0004J\u0010\u0010%\u001a\u00020#2\u0006\u0010&\u001a\u00020 H\u0004J\b\u0010'\u001a\u00020#H\u0004J\u000e\u0010(\u001a\u00020#2\u0006\u0010)\u001a\u00020*J\b\u0010+\u001a\u00020#H\u0004J\u0010\u0010,\u001a\u00020#2\u0006\u0010-\u001a\u00020.H\u0004J\b\u0010/\u001a\u00020#H\u0004J\u0010\u00100\u001a\u00020#2\u0006\u0010-\u001a\u00020.H\u0004J\u0010\u00101\u001a\u00020#2\u0006\u00102\u001a\u00020\fH\u0004J\b\u00103\u001a\u00020#H\u0004J\b\u00104\u001a\u00020#H\u0004J\b\u00105\u001a\u00020#H\u0004J\u0010\u00106\u001a\u00020#2\u0006\u00107\u001a\u00020\u0013H\u0004J\b\u00108\u001a\u00020#H\u0004J\u0010\u00109\u001a\u00020#2\u0006\u0010)\u001a\u00020*H\u0016J\u000e\u0010:\u001a\u00020#2\u0006\u00102\u001a\u00020\fJ\u0006\u0010;\u001a\u00020#J\b\u0010<\u001a\u00020#H\u0016R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR$\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0013\u0010\u0018\u001a\u0004\u0018\u00010\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u001c\u0010\u001c\u001a\u0004\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u000f\"\u0004\b\u001e\u0010\u0011R\u0012\u0010\u001f\u001a\u0004\u0018\u00010 X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010!\u00a8\u0006>"}, d2={"Lgames/thecodewarrior/bitfont/editor/mode/DefaultEditorMode;", "Lgames/thecodewarrior/bitfont/editor/mode/SimpleEditorMode;", "editor", "Lgames/thecodewarrior/bitfont/editor/Editor;", "(Lgames/thecodewarrior/bitfont/editor/Editor;)V", "clipboard", "Lgames/thecodewarrior/bitfont/editor/utils/Clipboard;", "getClipboard", "()Lgames/thecodewarrior/bitfont/editor/utils/Clipboard;", "setClipboard", "(Lgames/thecodewarrior/bitfont/editor/utils/Clipboard;)V", "value", "Lgames/thecodewarrior/bitfont/editor/mode/CursorPosition;", "cursor", "getCursor", "()Lgames/thecodewarrior/bitfont/editor/mode/CursorPosition;", "setCursor", "(Lgames/thecodewarrior/bitfont/editor/mode/CursorPosition;)V", "cursorPos", "Lgames/thecodewarrior/bitfont/utils/Vec2i;", "getCursorPos", "()Lgames/thecodewarrior/bitfont/utils/Vec2i;", "setCursorPos", "(Lgames/thecodewarrior/bitfont/utils/Vec2i;)V", "selectionRange", "Lgames/thecodewarrior/bitfont/editor/mode/CursorRange;", "getSelectionRange", "()Lgames/thecodewarrior/bitfont/editor/mode/CursorRange;", "selectionStart", "getSelectionStart", "setSelectionStart", "verticalMotionX", "", "Ljava/lang/Integer;", "copy", "", "cut", "delete", "end", "enter", "insert", "text", "", "jumpToMouse", "moveBackward", "breakType", "Lgames/thecodewarrior/bitfont/utils/extensions/BreakType;", "moveDown", "moveForward", "moveTo", "pos", "moveToLineEnd", "moveToLineStart", "moveUp", "normalMouseDrag", "previousPos", "paste", "receiveText", "resetCursor", "updateCursorPos", "updateText", "Companion", "bitfontcore"})
@ExperimentalBitfont
public class DefaultEditorMode
extends SimpleEditorMode {
    private Integer verticalMotionX;
    @NotNull
    private CursorPosition cursor;
    @Nullable
    private CursorPosition selectionStart;
    @NotNull
    private Vec2i cursorPos;
    @NotNull
    private Clipboard clipboard;
    @NotNull
    private static Function1<? super Editor, ? extends DefaultEditorMode> operatingSystemMode;
    public static final Companion Companion;

    @NotNull
    public final CursorPosition getCursor() {
        return this.cursor;
    }

    public final void setCursor(@NotNull CursorPosition value) {
        Intrinsics.checkParameterIsNotNull(value, "value");
        if (Intrinsics.areEqual(this.cursor, value) ^ true) {
            this.cursor = value;
            this.verticalMotionX = null;
            this.updateCursorPos();
        }
    }

    @Nullable
    public final CursorPosition getSelectionStart() {
        return this.selectionStart;
    }

    public final void setSelectionStart(@Nullable CursorPosition cursorPosition) {
        this.selectionStart = cursorPosition;
    }

    @Nullable
    public final CursorRange getSelectionRange() {
        CursorRange cursorRange;
        CursorPosition cursorPosition = this.selectionStart;
        if (cursorPosition != null) {
            CursorPosition cursorPosition2;
            CursorPosition it = cursorPosition2 = cursorPosition;
            cursorRange = this.cursor.getIndex() < it.getIndex() ? new CursorRange(this.cursor, it) : (this.cursor.getIndex() > it.getIndex() ? new CursorRange(it, this.cursor) : null);
        } else {
            cursorRange = null;
        }
        return cursorRange;
    }

    @NotNull
    public final Vec2i getCursorPos() {
        return this.cursorPos;
    }

    public final void setCursorPos(@NotNull Vec2i vec2i) {
        Intrinsics.checkParameterIsNotNull(vec2i, "<set-?>");
        this.cursorPos = vec2i;
    }

    @NotNull
    public final Clipboard getClipboard() {
        return this.clipboard;
    }

    public final void setClipboard(@NotNull Clipboard clipboard) {
        Intrinsics.checkParameterIsNotNull(clipboard, "<set-?>");
        this.clipboard = clipboard;
    }

    public final void resetCursor(@NotNull CursorPosition pos2) {
        Intrinsics.checkParameterIsNotNull(pos2, "pos");
        this.setCursor(pos2);
        this.selectionStart = null;
    }

    @Override
    public void updateText() {
        super.updateText();
        this.updateCursorPos();
    }

    public final void updateCursorPos() {
        TypesetString.GlyphRender atCursor = this.getInternals().getTypesetString().getGlyphMap().get(this.cursor.getIndex());
        TypesetString.GlyphRender beforeCursor = this.getInternals().getTypesetString().getGlyphMap().get(this.cursor.getIndex() - 1);
        if (this.cursor.getAfterPrevious()) {
            Object object;
            Object object2 = beforeCursor;
            if (object2 == null || (object2 = ((TypesetString.GlyphRender)object2).getPosAfter()) == null) {
                TypesetString.GlyphRender glyphRender = atCursor;
                object2 = object = glyphRender != null ? glyphRender.getPos() : null;
            }
            if (object2 == null) {
                object = new Vec2i(0, this.getEditor().getFont().getAscent());
            }
            this.cursorPos = object;
        } else {
            Object object;
            Object object3 = atCursor;
            if (object3 == null || (object3 = ((TypesetString.GlyphRender)object3).getPos()) == null) {
                TypesetString.GlyphRender glyphRender = beforeCursor;
                object3 = object = glyphRender != null ? glyphRender.getPosAfter() : null;
            }
            if (object3 == null) {
                object = new Vec2i(0, this.getEditor().getFont().getAscent());
            }
            this.cursorPos = object;
        }
    }

    @Override
    public void receiveText(@NotNull String text) {
        Intrinsics.checkParameterIsNotNull(text, "text");
        this.insert(text);
    }

    public final void insert(@NotNull String text) {
        Intrinsics.checkParameterIsNotNull(text, "text");
        CursorPosition selectionStart = this.selectionStart;
        if (selectionStart != null) {
            if (this.cursor.compareTo(selectionStart) < 0) {
                this.getContents().delete(this.cursor.getIndex(), selectionStart.getIndex());
                this.resetCursor(this.cursor);
            } else if (this.cursor.compareTo(selectionStart) > 0) {
                this.getContents().delete(selectionStart.getIndex(), this.cursor.getIndex());
                this.resetCursor(selectionStart);
            }
        }
        this.getContents().insert(this.cursor.getIndex(), text, new Pair[0]);
        this.resetCursor(new CursorPosition(this.cursor.getIndex() + text.length(), true));
        this.updateText();
    }

    protected final void delete(int end) {
        int rangeStart;
        CursorPosition cursorPosition = this.selectionStart;
        int n = rangeStart = cursorPosition != null ? cursorPosition.getIndex() : ClampKt.clamp(end, 0, this.getContents().getLength());
        if (this.cursor.getIndex() < rangeStart) {
            this.getContents().delete(this.cursor.getIndex(), rangeStart);
        } else if (this.cursor.getIndex() > rangeStart) {
            this.getContents().delete(rangeStart, this.cursor.getIndex());
            this.resetCursor(new CursorPosition(rangeStart, false));
        }
        this.selectionStart = null;
        this.updateText();
    }

    protected final void enter() {
        this.insert("\n");
    }

    protected final void moveTo(@NotNull CursorPosition pos2) {
        Intrinsics.checkParameterIsNotNull(pos2, "pos");
        CursorPosition cursorPosition = this.selectionStart;
        if (cursorPosition == null) {
            cursorPosition = this.cursor;
        }
        CursorPosition selectionStart = cursorPosition;
        this.resetCursor(pos2);
        if (this.getModifiers().contains(Modifier.SHIFT)) {
            this.selectionStart = selectionStart;
        }
    }

    /*
     * Unable to fully structure code
     */
    protected final void moveBackward(@NotNull BreakType breakType) {
        Intrinsics.checkParameterIsNotNull((Object)breakType, "breakType");
        iter = breakType.get();
        iter.setText(this.getContents().getPlaintext());
        v0 = iter;
        v1 = this.selectionStart;
        if (v1 == null) ** GOTO lbl-1000
        var4_3 = v1;
        var7_4 = v0;
        it = var4_3;
        var8_6 = (CursorPosition)ClampKt.min((Comparable)it, (Comparable)this.cursor);
        v0 = var7_4;
        v1 = var8_6;
        if (v1 != null) {
            v2 = v1.getIndex();
        } else lbl-1000:
        // 2 sources

        {
            v2 = this.cursor.getIndex();
        }
        newPos = v0.preceding(v2);
        if (newPos == -1) {
            this.moveTo(new CursorPosition(0, false));
        } else {
            this.moveTo(new CursorPosition(newPos, false));
        }
    }

    /*
     * Unable to fully structure code
     */
    protected final void moveForward(@NotNull BreakType breakType) {
        Intrinsics.checkParameterIsNotNull((Object)breakType, "breakType");
        iter = breakType.get();
        iter.setText(this.getContents().getPlaintext());
        v0 = iter;
        v1 = this.selectionStart;
        if (v1 == null) ** GOTO lbl-1000
        var4_3 = v1;
        var7_4 = v0;
        it = var4_3;
        var8_6 = (CursorPosition)ClampKt.max((Comparable)it, (Comparable)this.cursor);
        v0 = var7_4;
        v1 = var8_6;
        if (v1 != null) {
            v2 = v1.getIndex();
        } else lbl-1000:
        // 2 sources

        {
            v2 = this.cursor.getIndex();
        }
        newPos = v0.following(v2);
        if (newPos == -1) {
            this.moveTo(new CursorPosition(this.getContents().getLength(), true));
        } else {
            this.moveTo(new CursorPosition(newPos, true));
        }
    }

    protected final void moveUp() {
        block3: {
            int x2;
            TypesetString.GlyphRender glyphRender;
            CursorPosition cursorPosition;
            CursorPosition it;
            CursorPosition cursorPosition2 = this.selectionStart;
            int start = cursorPosition2 != null && (cursorPosition2 = (CursorPosition)ClampKt.min((Comparable)(it = (cursorPosition = cursorPosition2)), (Comparable)this.cursor)) != null ? cursorPosition2.getIndex() : this.cursor.getIndex();
            Integer max = (Integer)CollectionsKt.max((Iterable)this.getInternals().getTypesetString().getGlyphMap().keySet());
            if (max != null && Intrinsics.compare(start, max) > 0) {
                start = max;
            }
            TypesetString.GlyphRender glyphRender2 = this.getInternals().getTypesetString().getGlyphMap().get(start);
            if (glyphRender2 == null) break block3;
            TypesetString.GlyphRender it2 = glyphRender = glyphRender2;
            Integer n = this.verticalMotionX;
            int n2 = x2 = n != null ? n.intValue() : this.cursorPos.getX();
            if (it2.getLine() == 0) {
                this.setCursor(new CursorPosition(0, false));
            } else {
                Pair<Integer, Boolean> closest = this.getInternals().getTypesetString().getLines().get(it2.getLine() - 1).closestCharacter(x2);
                this.moveTo(new CursorPosition(closest));
            }
            this.verticalMotionX = x2;
        }
    }

    protected final void moveDown() {
        block3: {
            int x2;
            Object object;
            Object it;
            CursorPosition cursorPosition = this.selectionStart;
            if (cursorPosition == null || (cursorPosition = (CursorPosition)ClampKt.max((Comparable)(it = (object = cursorPosition)), (Comparable)this.cursor)) == null) {
                cursorPosition = this.cursor;
            }
            CursorPosition start = cursorPosition;
            TypesetString.GlyphRender glyphRender = this.getInternals().getTypesetString().getGlyphMap().get(start.getIndex());
            if (glyphRender == null) break block3;
            it = object = glyphRender;
            Integer n = this.verticalMotionX;
            int n2 = x2 = n != null ? n.intValue() : this.cursorPos.getX();
            if (((TypesetString.GlyphRender)it).getLine() == this.getInternals().getTypesetString().getLines().size() - 1) {
                this.setCursor(new CursorPosition(this.getContents().getLength(), false));
            } else {
                Pair<Integer, Boolean> closest = this.getInternals().getTypesetString().getLines().get(((TypesetString.GlyphRender)it).getLine() + 1).closestCharacter(x2);
                this.moveTo(new CursorPosition(closest));
            }
            this.verticalMotionX = x2;
        }
    }

    protected final void moveToLineStart() {
        block0: {
            TypesetString.GlyphRender glyphRender;
            TypesetString.GlyphRender glyphRender2 = this.getInternals().getTypesetString().getGlyphMap().get(this.cursor.getIndex());
            if (glyphRender2 == null) break block0;
            TypesetString.GlyphRender it = glyphRender = glyphRender2;
            this.moveTo(new CursorPosition(CollectionsKt.first(this.getInternals().getTypesetString().getLines().get(it.getLine()).getGlyphs()).getCharacterIndex(), false));
        }
    }

    protected final void moveToLineEnd() {
        block0: {
            TypesetString.GlyphRender glyphRender;
            TypesetString.GlyphRender glyphRender2 = this.getInternals().getTypesetString().getGlyphMap().get(this.cursor.getIndex());
            if (glyphRender2 == null) break block0;
            TypesetString.GlyphRender it = glyphRender = glyphRender2;
            this.moveTo(new CursorPosition(CollectionsKt.last(this.getInternals().getTypesetString().getLines().get(it.getLine()).getGlyphs()).getCharacterIndex() + 1, true));
        }
    }

    protected final void jumpToMouse() {
        CursorPosition newPos = new CursorPosition(this.getInternals().getTypesetString().closestCharacter(this.getMousePos()));
        if (this.getModifiers().contains(Modifier.SHIFT)) {
            CursorRange selection = this.getSelectionRange();
            if (selection == null) {
                this.selectionStart = this.cursor;
                this.setCursor(newPos);
            } else {
                this.setCursor(newPos);
                int n = selection.getStart().getIndex() - newPos.getIndex();
                int n2 = Math.abs(n);
                n = selection.getEndExclusive().getIndex() - newPos.getIndex();
                int n3 = n2;
                int n4 = Math.abs(n);
                this.selectionStart = n3 < n4 ? selection.getEndInclusive() : selection.getStart();
            }
            return;
        }
        this.resetCursor(newPos);
    }

    protected final void normalMouseDrag(@NotNull Vec2i previousPos) {
        Intrinsics.checkParameterIsNotNull(previousPos, "previousPos");
        CursorPosition cursorPosition = this.selectionStart;
        if (cursorPosition == null) {
            cursorPosition = this.cursor;
        }
        CursorPosition selectionStart = cursorPosition;
        this.setCursor(new CursorPosition(this.getInternals().getTypesetString().closestCharacter(this.getMousePos())));
        this.selectionStart = selectionStart;
    }

    protected final void paste() {
        block0: {
            String string;
            String it;
            CharSequence charSequence;
            String string2 = this.clipboard.getContents();
            if (string2 == null || !((charSequence = (CharSequence)(it = (string = string2))).length() > 0)) break block0;
            this.insert(it);
        }
    }

    protected final void copy() {
        block0: {
            CursorRange cursorRange;
            CursorRange cursorRange2 = this.getSelectionRange();
            if (cursorRange2 == null) break block0;
            CursorRange it = cursorRange = cursorRange2;
            int n = it.getStart().getIndex();
            this.clipboard.setContents(StringsKt.substring(this.getContents().getPlaintext(), new IntRange(n, it.getEndExclusive().getIndex())));
            this.selectionStart = null;
        }
    }

    protected final void cut() {
        block0: {
            CursorRange cursorRange;
            CursorRange cursorRange2 = this.getSelectionRange();
            if (cursorRange2 == null) break block0;
            CursorRange it = cursorRange = cursorRange2;
            this.copy();
            this.getContents().delete(it.getStart().getIndex(), it.getEndExclusive().getIndex());
            this.resetCursor(it.getStart());
            this.updateText();
        }
    }

    public DefaultEditorMode(@NotNull Editor editor) {
        Intrinsics.checkParameterIsNotNull(editor, "editor");
        super(editor);
        this.cursor = new CursorPosition(0, false);
        this.cursorPos = new Vec2i(0, 0);
        this.clipboard = InternalClipboard.INSTANCE;
        this.updateCursorPos();
    }

    static {
        Companion = new Companion(null);
        operatingSystemMode = Companion.operatingSystemMode.1.INSTANCE;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000e\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u0005R5\u0010\u0003\u001a\u001d\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\b\u0012\u0004\u0012\u00020\t0\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u000f"}, d2={"Lgames/thecodewarrior/bitfont/editor/mode/DefaultEditorMode$Companion;", "", "()V", "operatingSystemMode", "Lkotlin/Function1;", "Lgames/thecodewarrior/bitfont/editor/Editor;", "Lkotlin/ParameterName;", "name", "editor", "Lgames/thecodewarrior/bitfont/editor/mode/DefaultEditorMode;", "getOperatingSystemMode", "()Lkotlin/jvm/functions/Function1;", "setOperatingSystemMode", "(Lkotlin/jvm/functions/Function1;)V", "systemMode", "bitfontcore"})
    public static final class Companion {
        @NotNull
        public final Function1<Editor, DefaultEditorMode> getOperatingSystemMode() {
            return operatingSystemMode;
        }

        public final void setOperatingSystemMode(@NotNull Function1<? super Editor, ? extends DefaultEditorMode> function1) {
            Intrinsics.checkParameterIsNotNull(function1, "<set-?>");
            operatingSystemMode = function1;
        }

        @NotNull
        public final DefaultEditorMode systemMode(@NotNull Editor editor) {
            Intrinsics.checkParameterIsNotNull(editor, "editor");
            return this.getOperatingSystemMode().invoke(editor);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

