/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.librarianlib.shade.icu.text;

import com.teamwizardry.librarianlib.shade.icu.text.NFRule;
import com.teamwizardry.librarianlib.shade.icu.text.NFRuleSet;
import com.teamwizardry.librarianlib.shade.icu.text.NFSubstitution;

class MultiplierSubstitution
extends NFSubstitution {
    long divisor;

    MultiplierSubstitution(int pos2, NFRule rule, NFRuleSet ruleSet, String description) {
        super(pos2, ruleSet, description);
        this.divisor = rule.getDivisor();
        if (this.divisor == 0L) {
            throw new IllegalStateException("Substitution with divisor 0 " + description.substring(0, pos2) + " | " + description.substring(pos2));
        }
    }

    @Override
    public void setDivisor(int radix, short exponent) {
        this.divisor = NFRule.power(radix, exponent);
        if (this.divisor == 0L) {
            throw new IllegalStateException("Substitution with divisor 0");
        }
    }

    @Override
    public boolean equals(Object that) {
        return super.equals(that) && this.divisor == ((MultiplierSubstitution)that).divisor;
    }

    @Override
    public long transformNumber(long number) {
        return (long)Math.floor(number / this.divisor);
    }

    @Override
    public double transformNumber(double number) {
        if (this.ruleSet == null) {
            return number / (double)this.divisor;
        }
        return Math.floor(number / (double)this.divisor);
    }

    @Override
    public double composeRuleValue(double newRuleValue, double oldRuleValue) {
        return newRuleValue * (double)this.divisor;
    }

    @Override
    public double calcUpperBound(double oldUpperBound) {
        return this.divisor;
    }

    @Override
    char tokenChar() {
        return '<';
    }
}

