/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.librarianlib.features.sprite;

import com.teamwizardry.librarianlib.features.kotlin.Client;
import com.teamwizardry.librarianlib.features.sprite.ISprite;
import com.teamwizardry.librarianlib.features.sprite.SpriteDefinition;
import com.teamwizardry.librarianlib.features.sprite.Texture;
import java.awt.image.BufferedImage;
import java.awt.image.RasterFormatException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.client.renderer.texture.PngSizeInfo;
import net.minecraft.client.resources.IResource;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

@SideOnly(value=Side.CLIENT)
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u001e\n\u0002\u0010\u0002\n\u0002\b\f\b\u0007\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B#\b\u0017\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\nJ\b\u0010J\u001a\u00020KH\u0016J\u0010\u0010L\u001a\u00020\b2\u0006\u0010M\u001a\u00020\bH\u0002J\u0015\u0010N\u001a\u00020K2\u0006\u0010\r\u001a\u00020\fH\u0000\u00a2\u0006\u0002\bOJ\u000e\u0010P\u001a\u00020K2\u0006\u0010Q\u001a\u00020\u0017J\u0010\u0010R\u001a\u00020\u001e2\u0006\u0010M\u001a\u00020\bH\u0016J\u0010\u0010S\u001a\u00020\u001e2\u0006\u0010M\u001a\u00020\bH\u0016J\u0010\u0010T\u001a\u00020\u001e2\u0006\u0010M\u001a\u00020\bH\u0016J\u0010\u0010U\u001a\u00020\u001e2\u0006\u0010M\u001a\u00020\bH\u0016J\b\u0010V\u001a\u00020(H\u0016R$\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\t\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0014R0\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\u00020\u001e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0014\u0010!\u001a\u00020\u001e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010 R\u0014\u0010#\u001a\u00020\u001e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010 R\u0014\u0010%\u001a\u00020\u001e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010 R\u0011\u0010'\u001a\u00020(8F\u00a2\u0006\u0006\u001a\u0004\b)\u0010*R\u0014\u0010+\u001a\u00020,8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010.R\u0014\u0010/\u001a\u00020,8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u0010.R\u0014\u00101\u001a\u00020,8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b2\u0010.R\u0014\u00103\u001a\u00020,8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b4\u0010.R$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0003@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u00106\"\u0004\b7\u0010\u0004R\u001a\u00108\u001a\u00020\b8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b9\u0010:\u001a\u0004\b;\u0010\u0014R\u0014\u0010<\u001a\u00020\u001e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b=\u0010 R\u001a\u0010>\u001a\u00020\b8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b?\u0010:\u001a\u0004\b@\u0010\u0014R\u001a\u0010A\u001a\u00020\b8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\bB\u0010:\u001a\u0004\bC\u0010\u0014R\u001a\u0010D\u001a\u00020\b8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\bE\u0010:\u001a\u0004\bF\u0010\u0014R\u0014\u0010G\u001a\u00020\u001e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bH\u0010 R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bI\u0010\u0014\u00a8\u0006W"}, d2={"Lcom/teamwizardry/librarianlib/features/sprite/Sprite;", "Lcom/teamwizardry/librarianlib/features/sprite/ISprite;", "tex", "Lcom/teamwizardry/librarianlib/features/sprite/Texture;", "(Lcom/teamwizardry/librarianlib/features/sprite/Texture;)V", "loc", "Lnet/minecraft/util/ResourceLocation;", "width", "", "height", "(Lnet/minecraft/util/ResourceLocation;II)V", "<set-?>", "Lcom/teamwizardry/librarianlib/features/sprite/SpriteDefinition;", "def", "getDef", "()Lcom/teamwizardry/librarianlib/features/sprite/SpriteDefinition;", "setDef", "(Lcom/teamwizardry/librarianlib/features/sprite/SpriteDefinition;)V", "frameCount", "getFrameCount", "()I", "getHeight", "", "Ljava/awt/image/BufferedImage;", "images", "getImages", "()Ljava/util/List;", "setImages", "(Ljava/util/List;)V", "maxUCap", "", "getMaxUCap", "()F", "maxVCap", "getMaxVCap", "minUCap", "getMinUCap", "minVCap", "getMinVCap", "name", "", "getName", "()Ljava/lang/String;", "pinBottom", "", "getPinBottom", "()Z", "pinLeft", "getPinLeft", "pinRight", "getPinRight", "pinTop", "getPinTop", "getTex", "()Lcom/teamwizardry/librarianlib/features/sprite/Texture;", "setTex", "u", "u$annotations", "()V", "getU", "uSize", "getUSize", "uvHeight", "uvHeight$annotations", "getUvHeight", "uvWidth", "uvWidth$annotations", "getUvWidth", "v", "v$annotations", "getV", "vSize", "getVSize", "getWidth", "bind", "", "frameMultiplier", "animFrames", "init", "init$librarianlib_1_12_2", "loadImage", "full", "maxU", "maxV", "minU", "minV", "toString", "librarianlib-1.12.2"})
public final class Sprite
implements ISprite {
    @NotNull
    private Texture tex;
    @NotNull
    private SpriteDefinition def;
    @NotNull
    private List<? extends BufferedImage> images;

    @NotNull
    public final Texture getTex() {
        return this.tex;
    }

    protected final void setTex(@NotNull Texture texture) {
        Intrinsics.checkParameterIsNotNull(texture, "<set-?>");
        this.tex = texture;
    }

    @NotNull
    public final SpriteDefinition getDef() {
        return this.def;
    }

    private final void setDef(SpriteDefinition spriteDefinition) {
        this.def = spriteDefinition;
    }

    @NotNull
    public final String getName() {
        return this.def.getName();
    }

    @Override
    public boolean getPinTop() {
        return this.def.getPinTop();
    }

    @Override
    public boolean getPinBottom() {
        return this.def.getPinBottom();
    }

    @Override
    public boolean getPinLeft() {
        return this.def.getPinLeft();
    }

    @Override
    public boolean getPinRight() {
        return this.def.getPinRight();
    }

    @Override
    public int getFrameCount() {
        int n = 1;
        int n2 = this.def.getFrames().length;
        return Math.max(n, n2);
    }

    @Override
    public int getWidth() {
        return this.def.getW() / this.tex.getLogicalScale();
    }

    @Override
    public int getHeight() {
        return this.def.getH() / this.tex.getLogicalScale();
    }

    @Override
    public float getUSize() {
        return (float)this.def.getW() / (float)this.tex.getWidth();
    }

    @Override
    public float getVSize() {
        return (float)this.def.getH() / (float)this.tex.getHeight();
    }

    @NotNull
    public final List<BufferedImage> getImages() {
        return this.images;
    }

    private final void setImages(List<? extends BufferedImage> list2) {
        this.images = list2;
    }

    @Deprecated(message="UV coordinates should rarely be directly used", replaceWith=@ReplaceWith(imports={}, expression="def.w"))
    public static /* synthetic */ void uvWidth$annotations() {
    }

    public final int getUvWidth() {
        return this.def.getW();
    }

    @Deprecated(message="UV coordinates should rarely be directly used", replaceWith=@ReplaceWith(imports={}, expression="def.h"))
    public static /* synthetic */ void uvHeight$annotations() {
    }

    public final int getUvHeight() {
        return this.def.getH();
    }

    @Deprecated(message="UV coordinates should rarely be directly used", replaceWith=@ReplaceWith(imports={}, expression="def.u"))
    public static /* synthetic */ void u$annotations() {
    }

    public final int getU() {
        return this.def.getU();
    }

    @Deprecated(message="UV coordinates should rarely be directly used", replaceWith=@ReplaceWith(imports={}, expression="def.v"))
    public static /* synthetic */ void v$annotations() {
    }

    public final int getV() {
        return this.def.getV();
    }

    public final void init$librarianlib_1_12_2(@NotNull SpriteDefinition def) {
        Intrinsics.checkParameterIsNotNull(def, "def");
        this.def = def;
    }

    /*
     * WARNING - void declaration
     */
    public final void loadImage(@NotNull BufferedImage full) {
        Collection<BufferedImage> collection;
        void $receiver$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull(full, "full");
        Exception exception = null;
        Object object = RangesKt.until(0, this.getFrameCount());
        Sprite sprite = this;
        void var4_5 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        Iterator iterator2 = $receiver$iv$iv.iterator();
        while (iterator2.hasNext()) {
            BufferedImage bufferedImage;
            void i;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
            collection = destination$iv$iv;
            int minX = (int)(this.minU((int)i) * (float)full.getWidth());
            int maxX = (int)(this.maxU((int)i) * (float)full.getWidth());
            int minY = (int)(this.minV((int)i) * (float)full.getHeight());
            int maxY = (int)(this.maxV((int)i) * (float)full.getHeight());
            try {
                bufferedImage = full.getSubimage(minX, minY, maxX - minX, maxY - minY);
            }
            catch (RasterFormatException e) {
                exception = e;
                bufferedImage = new BufferedImage(1, 1, 2);
            }
            BufferedImage bufferedImage2 = bufferedImage;
            collection.add(bufferedImage2);
        }
        collection = (List)destination$iv$iv;
        sprite.images = collection;
        Exception exception2 = exception;
        if (exception2 != null) {
            Object it = object = exception2;
            throw (Throwable)it;
        }
    }

    private final int frameMultiplier(int animFrames) {
        int[] nArray = this.def.getFrames();
        return nArray.length == 0 ? 0 : this.def.getFrames()[animFrames % this.def.getFrames().length];
    }

    @Override
    public float minU(int animFrames) {
        return (float)(this.def.getU() + this.def.getOffsetU() * this.frameMultiplier(animFrames)) / (float)this.tex.getWidth();
    }

    @Override
    public float minV(int animFrames) {
        return (float)(this.def.getV() + this.def.getOffsetV() * this.frameMultiplier(animFrames)) / (float)this.tex.getHeight();
    }

    @Override
    public float maxU(int animFrames) {
        return (float)(this.def.getU() + this.def.getW() + this.def.getOffsetU() * this.frameMultiplier(animFrames)) / (float)this.tex.getWidth();
    }

    @Override
    public float maxV(int animFrames) {
        return (float)(this.def.getV() + this.def.getH() + this.def.getOffsetV() * this.frameMultiplier(animFrames)) / (float)this.tex.getHeight();
    }

    @Override
    public float getMinUCap() {
        return (float)this.def.getMinUCap() / (float)this.def.getW();
    }

    @Override
    public float getMinVCap() {
        return (float)this.def.getMinVCap() / (float)this.def.getH();
    }

    @Override
    public float getMaxUCap() {
        return (float)this.def.getMaxUCap() / (float)this.def.getW();
    }

    @Override
    public float getMaxVCap() {
        return (float)this.def.getMaxVCap() / (float)this.def.getH();
    }

    @Override
    public void bind() {
        this.tex.bind();
    }

    @NotNull
    public String toString() {
        return "Sprite(texture=" + this.tex.getLoc() + ", name=" + this.getName() + ')';
    }

    public Sprite(@NotNull Texture tex) {
        Intrinsics.checkParameterIsNotNull(tex, "tex");
        this.def = new SpriteDefinition("");
        Sprite sprite = this;
        List list2 = CollectionsKt.emptyList();
        sprite.images = list2;
        this.tex = tex;
    }

    @JvmOverloads
    public Sprite(@NotNull ResourceLocation loc, int width, int height) {
        Intrinsics.checkParameterIsNotNull(loc, "loc");
        this.def = new SpriteDefinition("");
        Sprite sprite = this;
        List list2 = CollectionsKt.emptyList();
        sprite.images = list2;
        PngSizeInfo pngSizeInfo = PngSizeInfo.func_188532_a((IResource)Client.INSTANCE.getMinecraft().func_110442_L().func_110536_a(loc));
        int pngWidth = pngSizeInfo.field_188533_a;
        int pngHeight = pngSizeInfo.field_188534_b;
        if (width > 0 && height <= 0) {
            pngWidth = width;
            pngHeight = pngHeight * width / pngWidth;
        } else if (width <= 0 && height > 0) {
            pngHeight = height;
            pngWidth = pngWidth * height / pngHeight;
        } else if (width > 0 && height > 0) {
            pngWidth = width;
            pngHeight = height;
        }
        this.def.setU(0);
        this.def.setV(0);
        this.def.setW(pngWidth);
        this.def.setH(pngHeight);
        this.def.setFrames(new int[0]);
        this.tex = new Texture(loc, pngWidth, pngHeight);
        Map<String, Sprite> map = this.tex.get_sprites$librarianlib_1_12_2();
        String string = loc.func_110623_a();
        Intrinsics.checkExpressionValueIsNotNull(string, "loc.path");
        String string2 = string;
        Sprite sprite2 = this;
        map.put(string2, sprite2);
        this.tex.loadSpriteData();
    }

    @JvmOverloads
    public /* synthetic */ Sprite(ResourceLocation resourceLocation, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = 0;
        }
        this(resourceLocation, n, n2);
    }

    @JvmOverloads
    public Sprite(@NotNull ResourceLocation loc, int width) {
        this(loc, width, 0, 4, null);
    }

    @JvmOverloads
    public Sprite(@NotNull ResourceLocation loc) {
        this(loc, 0, 0, 6, null);
    }

    @Override
    public float minU() {
        return ISprite.DefaultImpls.minU(this);
    }

    @Override
    public float minV() {
        return ISprite.DefaultImpls.minV(this);
    }

    @Override
    public float maxU() {
        return ISprite.DefaultImpls.maxU(this);
    }

    @Override
    public float maxV() {
        return ISprite.DefaultImpls.maxV(this);
    }

    @Override
    public void draw(int animTicks, float x2, float y) {
        ISprite.DefaultImpls.draw(this, animTicks, x2, y);
    }

    @Override
    public void draw(int animTicks, float x2, float y, float width, float height) {
        ISprite.DefaultImpls.draw(this, animTicks, x2, y, width, height);
    }

    @Override
    @Deprecated(message="Replaced with sprite pinning functionality", replaceWith=@ReplaceWith(imports={}, expression="pinnedWrapper(!reverseY, reverseY, !reverseX, reverseX).draw(animTicks, x, y, width.toFloat(), height.toFloat())"))
    public void drawClipped(int animTicks, float x2, float y, int width, int height, boolean reverseX, boolean reverseY) {
        ISprite.DefaultImpls.drawClipped(this, animTicks, x2, y, width, height, reverseX, reverseY);
    }

    @Override
    @Deprecated(message="Replaced with sprite pinning functionality", replaceWith=@ReplaceWith(imports={}, expression="pinnedWrapper(true, true, false, false).draw(animTicks, x, y, width.toFloat(), height.toFloat())"))
    public void drawClipped(int animTicks, float x2, float y, int width, int height) {
        ISprite.DefaultImpls.drawClipped(this, animTicks, x2, y, width, height);
    }

    @Override
    public int getInWidth() {
        return ISprite.DefaultImpls.getInWidth(this);
    }

    @Override
    public int getInHeight() {
        return ISprite.DefaultImpls.getInHeight(this);
    }
}

