/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.librarianlib.features.shader;

import com.teamwizardry.librarianlib.core.LibrarianLog;
import com.teamwizardry.librarianlib.core.common.LibLibConfig;
import com.teamwizardry.librarianlib.features.kotlin.Client;
import com.teamwizardry.librarianlib.features.shader.Shader;
import com.teamwizardry.librarianlib.features.shader.ShaderHelper;
import com.teamwizardry.librarianlib.features.shader.uniforms.FloatTypes;
import com.teamwizardry.librarianlib.features.utilities.client.ClientRunnable;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.resources.IResource;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.ARBShaderObjects;
import org.lwjgl.opengl.GL20;

@SideOnly(value=Side.CLIENT)
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0010\u001a\u0002H\u0011\"\b\b\u0000\u0010\u0011*\u00020\u000f2\u0006\u0010\u0012\u001a\u0002H\u0011\u00a2\u0006\u0002\u0010\u0013J\u0010\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u000fH\u0002J\u0018\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0004H\u0002J\u0010\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u0004H\u0002J\u0006\u0010\u001b\u001a\u00020\u001cJ\u0006\u0010\u001d\u001a\u00020\u001cJ\u0010\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0006\u0010!\u001a\u00020\u001cJ\u001f\u0010\"\u001a\u00020\u001c\"\b\b\u0000\u0010\u0011*\u00020\u000f2\b\u0010\u0012\u001a\u0004\u0018\u0001H\u0011\u00a2\u0006\u0002\u0010#J/\u0010\"\u001a\u00020\u001c\"\b\b\u0000\u0010\u0011*\u00020\u000f2\b\u0010\u0012\u001a\u0004\u0018\u0001H\u00112\u000e\u0010$\u001a\n\u0012\u0004\u0012\u0002H\u0011\u0018\u00010%\u00a2\u0006\u0002\u0010&J\u0006\u0010'\u001a\u00020\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/teamwizardry/librarianlib/features/shader/ShaderHelper;", "", "()V", "FRAG", "", "VERT", "enableValidation", "", "getEnableValidation", "()Z", "setEnableValidation", "(Z)V", "hasLoaded", "shaders", "Ljava/util/ArrayList;", "Lcom/teamwizardry/librarianlib/features/shader/Shader;", "addShader", "T", "shader", "(Lcom/teamwizardry/librarianlib/features/shader/Shader;)Lcom/teamwizardry/librarianlib/features/shader/Shader;", "createProgram", "createShader", "fileText", "", "shaderType", "getLogInfo", "obj", "init", "", "initShaders", "readFileAsString", "resourceLocation", "Lnet/minecraft/util/ResourceLocation;", "releaseShader", "useShader", "(Lcom/teamwizardry/librarianlib/features/shader/Shader;)V", "callback", "Ljava/util/function/Consumer;", "(Lcom/teamwizardry/librarianlib/features/shader/Shader;Ljava/util/function/Consumer;)V", "useShaders", "librarianlib-1.12.2"})
public final class ShaderHelper {
    private static boolean enableValidation;
    private static final int VERT = 35633;
    private static final int FRAG = 35632;
    private static final ArrayList<Shader> shaders;
    private static boolean hasLoaded;
    public static final ShaderHelper INSTANCE;

    public final boolean getEnableValidation() {
        return enableValidation;
    }

    public final void setEnableValidation(boolean bl) {
        enableValidation = bl;
    }

    public final void init() {
        this.initShaders();
        ClientRunnable.registerReloadHandler(init.1.INSTANCE);
    }

    @NotNull
    public final <T extends Shader> T addShader(@NotNull T shader) {
        Intrinsics.checkParameterIsNotNull(shader, "shader");
        shaders.add(shader);
        if (hasLoaded && this.useShaders()) {
            this.createProgram(shader);
        }
        return shader;
    }

    public final void initShaders() {
        if (!this.useShaders()) {
            return;
        }
        Iterator<Shader> iterator2 = shaders.iterator();
        while (iterator2.hasNext()) {
            Shader shader;
            Shader shader2 = shader = iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull(shader2, "shader");
            this.createProgram(shader2);
        }
        hasLoaded = true;
    }

    public final <T extends Shader> void useShader(@Nullable T shader, @Nullable Consumer<T> callback) {
        block6: {
            if (shader == null) {
                ARBShaderObjects.glUseProgramObjectARB((int)0);
                return;
            }
            if (!this.useShaders()) {
                return;
            }
            ARBShaderObjects.glUseProgramObjectARB((int)shader.getGlName());
            if (shader.getTime() != null) {
                long nanos = System.nanoTime();
                double seconds = (double)nanos / 1.0E9;
                seconds %= 100000.0;
                FloatTypes.FloatUniform floatUniform = shader.getTime();
                if (floatUniform != null) {
                    floatUniform.set(seconds);
                }
            }
            shader.uniformDefaults();
            if (enableValidation) {
                ARBShaderObjects.glValidateProgramARB((int)shader.getGlName());
                if (ARBShaderObjects.glGetObjectParameteriARB((int)shader.getGlName(), (int)35715) == 0) {
                    LibrarianLog.INSTANCE.error(this.getLogInfo(shader.getGlName()), new Object[0]);
                }
            }
            Consumer<T> consumer = callback;
            if (consumer == null) break block6;
            consumer.accept(shader);
        }
    }

    public final <T extends Shader> void useShader(@Nullable T shader) {
        this.useShader(shader, null);
    }

    public final void releaseShader() {
        this.useShader(null);
    }

    public final boolean useShaders() {
        try {
            FMLCommonHandler fMLCommonHandler = FMLCommonHandler.instance();
            Intrinsics.checkExpressionValueIsNotNull(fMLCommonHandler, "FMLCommonHandler.instance()");
            return fMLCommonHandler.getEffectiveSide() == Side.CLIENT && LibLibConfig.getShaders() && OpenGlHelper.field_148824_g;
        }
        catch (NoSuchFieldError ignored) {
            return false;
        }
    }

    private final int createProgram(Shader shader) {
        int program;
        ResourceLocation vert = shader.getVertRl();
        ResourceLocation frag = shader.getFragRl();
        int vertId = 0;
        int fragId = 0;
        if (vert != null) {
            String vertText;
            try {
                vertText = this.readFileAsString(vert);
                vertId = this.createShader(vertText, VERT);
            }
            catch (Exception e) {
                vertText = "ERROR: \n" + e.toString();
                for (StackTraceElement elem : e.getStackTrace()) {
                    vertText = vertText + "\n" + elem.toString();
                }
            }
        }
        if (frag != null) {
            try {
                String fragText = this.readFileAsString(frag);
                fragId = this.createShader(fragText, FRAG);
            }
            catch (Exception e) {
                String fragText = "ERROR: \n" + e.toString();
                for (StackTraceElement elem : e.getStackTrace()) {
                    fragText = fragText + "\n" + elem.toString();
                }
            }
        }
        if (shader.getGlName() != 0) {
            GL20.glDeleteProgram((int)shader.getGlName());
        }
        if ((program = ARBShaderObjects.glCreateProgramObjectARB()) == 0) {
            return 0;
        }
        if (vert != null) {
            ARBShaderObjects.glAttachObjectARB((int)program, (int)vertId);
        }
        if (frag != null) {
            ARBShaderObjects.glAttachObjectARB((int)program, (int)fragId);
        }
        ARBShaderObjects.glLinkProgramARB((int)program);
        if (ARBShaderObjects.glGetObjectParameteriARB((int)program, (int)35714) == 0) {
            LibrarianLog.INSTANCE.error(this.getLogInfo(program), new Object[0]);
            return 0;
        }
        LibrarianLog.INSTANCE.info("Created program %d - VERT:'%s' FRAG:'%s'", program, vert, frag);
        shader.init(program);
        return program;
    }

    private final int createShader(String fileText, int shaderType) {
        int shader = 0;
        try {
            shader = ARBShaderObjects.glCreateShaderObjectARB((int)shaderType);
            if (shader == 0) {
                return 0;
            }
            ARBShaderObjects.glShaderSourceARB((int)shader, (CharSequence)fileText);
            ARBShaderObjects.glCompileShaderARB((int)shader);
            if (ARBShaderObjects.glGetObjectParameteriARB((int)shader, (int)35713) == 0) {
                throw (Throwable)new RuntimeException("Error creating shader: " + this.getLogInfo(shader));
            }
            return shader;
        }
        catch (Exception e) {
            ARBShaderObjects.glDeleteObjectARB((int)shader);
            e.printStackTrace();
            return -1;
        }
    }

    private final String getLogInfo(int obj) {
        String string = ARBShaderObjects.glGetInfoLogARB((int)obj, (int)ARBShaderObjects.glGetObjectParameteriARB((int)obj, (int)35716));
        Intrinsics.checkExpressionValueIsNotNull(string, "ARBShaderObjects.glGetIn\u2026ECT_INFO_LOG_LENGTH_ARB))");
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String readFileAsString(ResourceLocation resourceLocation) throws Exception {
        String string;
        IResource iResource = Client.INSTANCE.getResourceManager().func_110536_a(resourceLocation);
        Intrinsics.checkExpressionValueIsNotNull(iResource, "Client.resourceManager.g\u2026esource(resourceLocation)");
        Closeable closeable = iResource.func_110527_b();
        Throwable throwable = null;
        try {
            InputStream it;
            InputStream inputStream = it = (InputStream)closeable;
            Intrinsics.checkExpressionValueIsNotNull(inputStream, "it");
            InputStream inputStream2 = inputStream;
            Charset charset = Charsets.UTF_8;
            string = TextStreamsKt.readText(new InputStreamReader(inputStream2, charset));
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
        return string;
    }

    private ShaderHelper() {
    }

    static {
        ShaderHelper shaderHelper;
        INSTANCE = shaderHelper = new ShaderHelper();
        VERT = 35633;
        FRAG = 35632;
        shaders = new ArrayList();
    }
}

