/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.world.feature;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.IMerchant;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.VillagerRegistry;
import svenhjol.charm.Charm;
import svenhjol.charm.crafting.feature.Lantern;
import svenhjol.charm.crafting.feature.SuspiciousSoup;
import svenhjol.charm.enchanting.feature.CurseBreak;
import svenhjol.charm.enchanting.feature.Salvage;
import svenhjol.meson.Feature;
import svenhjol.meson.helper.EnchantmentHelper;
import svenhjol.meson.registry.VillagerRegistry;

public class VillagerTrades
extends Feature {
    @Override
    public String getDescription() {
        return "Villagers have additional trades.  Librarians can buy back enchanted books, tool smiths repair very damaged anvils for a small iron cost, and zombie flesh is more useful.";
    }

    @SubscribeEvent
    public void onRegisterVillagers(RegistryEvent.Register<VillagerRegistry.VillagerProfession> event) {
        if (Charm.hasFeature(SuspiciousSoup.class)) {
            VillagerRegistry.farmer.addTrade(2, new EntityVillager.ITradeList[]{new SuspiciousSoupTrade()});
            VillagerRegistry.fisherman.addTrade(2, new EntityVillager.ITradeList[]{new SuspiciousSoupTrade()});
        }
        VillagerRegistry.librarian.addTrade(1, new EntityVillager.ITradeList[]{new EnchantedBookTrade()});
        VillagerRegistry.cleric.addTrade(3, new EntityVillager.ITradeList[]{new CurseBreakTrade()});
        VillagerRegistry.butcher.addTrade(1, new EntityVillager.ITradeList[]{new ZombieFlesh(Items.field_151082_bd, Items.field_151147_al, Items.field_179558_bo, Items.field_179561_bm)});
        VillagerRegistry.leatherWorker.addTrade(1, new EntityVillager.ITradeList[]{new ZombieFlesh(Items.field_151116_aA)});
        VillagerRegistry.smith.addTrade(1, new EntityVillager.ITradeList[]{new DamagedAnvilsTrade()});
        VillagerRegistry.smith.addTrade(2, new EntityVillager.ITradeList[]{new LanternsTrade()});
        VillagerRegistry.smith.addTrade(3, new EntityVillager.ITradeList[]{new SalvageTrade()});
        VillagerRegistry.weapon.addTrade(1, new EntityVillager.ITradeList[]{new DamagedAnvilsTrade()});
        VillagerRegistry.weapon.addTrade(2, new EntityVillager.ITradeList[]{new LanternsTrade()});
        VillagerRegistry.weapon.addTrade(3, new EntityVillager.ITradeList[]{new SalvageTrade()});
        VillagerRegistry.tool.addTrade(1, new EntityVillager.ITradeList[]{new DamagedAnvilsTrade()});
        VillagerRegistry.tool.addTrade(2, new EntityVillager.ITradeList[]{new LanternsTrade()});
        VillagerRegistry.tool.addTrade(3, new EntityVillager.ITradeList[]{new SalvageTrade()});
        VillagerRegistry.tool.addTrade(4, new EntityVillager.ITradeList[]{new FortuneShovelTrade()});
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }

    public static class EnchantedBookTrade
    implements EntityVillager.ITradeList {
        public void func_190888_a(IMerchant merchant, MerchantRecipeList recipeList, Random random) {
            ItemStack book = new ItemStack(Items.field_151134_bR);
            int emeraldCount = random.nextInt(4) + 1;
            recipeList.add((Object)new MerchantRecipe(book, new ItemStack(Items.field_151166_bC, emeraldCount)));
        }
    }

    public static class CurseBreakTrade
    implements EntityVillager.ITradeList {
        public void func_190888_a(IMerchant merchant, MerchantRecipeList recipeList, Random random) {
            int emeraldCount = 2 * (random.nextInt(15) + 5);
            ItemStack book = new ItemStack(Items.field_151134_bR);
            EnchantmentHelper.func_82782_a((Map)new HashMap<Enchantment, Integer>(){
                {
                    this.put(CurseBreak.enchantment, 1);
                }
            }, (ItemStack)book);
            recipeList.add((Object)new MerchantRecipe(new ItemStack(Items.field_151166_bC, emeraldCount), new ItemStack(Items.field_151122_aG), book));
        }
    }

    public static class SalvageTrade
    implements EntityVillager.ITradeList {
        public void func_190888_a(IMerchant merchant, MerchantRecipeList recipeList, Random random) {
            int emeraldCount = random.nextInt(15) + 5;
            ItemStack book = new ItemStack(Items.field_151134_bR);
            EnchantmentHelper.func_82782_a((Map)new HashMap<Enchantment, Integer>(){
                {
                    this.put(Salvage.enchantment, 1);
                }
            }, (ItemStack)book);
            recipeList.add((Object)new MerchantRecipe(new ItemStack(Items.field_151166_bC, emeraldCount), new ItemStack(Items.field_151122_aG), book));
        }
    }

    public static class ZombieFlesh
    implements EntityVillager.ITradeList {
        public final Item[] forWhat;

        public ZombieFlesh(Item ... forWhat) {
            this.forWhat = forWhat;
        }

        public void func_190888_a(IMerchant merchant, MerchantRecipeList recipeList, Random random) {
            int fleshCount = random.nextInt(10) + 5;
            int tradeCount = Math.min(random.nextInt(2) + 2, fleshCount);
            List<Item> items = Arrays.asList(this.forWhat);
            ItemStack zombieFlesh = new ItemStack(Items.field_151078_bh, fleshCount);
            ItemStack traded = new ItemStack(items.get(random.nextInt(items.size())), tradeCount);
            recipeList.add((Object)new MerchantRecipe(zombieFlesh, traded));
        }
    }

    public static class DamagedAnvilsTrade
    implements EntityVillager.ITradeList {
        public void func_190888_a(IMerchant merchant, MerchantRecipeList recipeList, Random random) {
            int ironCount = random.nextInt(4) + 4;
            recipeList.add((Object)new MerchantRecipe(new ItemStack(Blocks.field_150467_bQ, 1, 2), new ItemStack(Items.field_151042_j, ironCount), new ItemStack(Blocks.field_150467_bQ)));
        }
    }

    public static class FortuneShovelTrade
    implements EntityVillager.ITradeList {
        public void func_190888_a(IMerchant merchant, MerchantRecipeList recipeList, Random random) {
            int emeraldCount = random.nextInt(5) + 12;
            ItemStack shovel = new ItemStack(Items.field_151047_v);
            EnchantmentHelper.func_82782_a((Map)new HashMap<Enchantment, Integer>(){
                {
                    this.put(Enchantments.field_185308_t, 3);
                }
            }, (ItemStack)shovel);
            recipeList.add((Object)new MerchantRecipe(new ItemStack(Items.field_151166_bC, emeraldCount), shovel));
        }
    }

    public static class LanternsTrade
    implements EntityVillager.ITradeList {
        public void func_190888_a(IMerchant merchant, MerchantRecipeList recipeList, Random random) {
            int emeraldCount = random.nextInt(1) + 1;
            int lanternCount = random.nextInt(2) + 2;
            ItemStack lanterns = new ItemStack((Block)Lantern.getDefaultLantern(), lanternCount);
            recipeList.add((Object)new MerchantRecipe(new ItemStack(Items.field_151166_bC, emeraldCount), lanterns));
        }
    }

    public static class SuspiciousSoupTrade
    implements EntityVillager.ITradeList {
        public void func_190888_a(IMerchant merchant, MerchantRecipeList recipeList, Random random) {
            int beetrootCount = random.nextInt(10) + 5;
            ItemStack soup = new ItemStack(SuspiciousSoup.suspiciousSoup, 1, random.nextInt(SuspiciousSoup.maxTypes));
            recipeList.add((Object)new MerchantRecipe(new ItemStack(Items.field_185164_cV, beetrootCount), soup));
        }
    }
}

