/*
 * Decompiled with CFR 0.152.
 */
package leviathan143.loottweaker.common.zenscript;

import com.google.common.annotations.VisibleForTesting;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.data.IData;
import java.util.Map;
import java.util.Optional;
import leviathan143.loottweaker.common.LootTweaker;
import leviathan143.loottweaker.common.darkmagic.LootTableManagerAccessors;
import leviathan143.loottweaker.common.lib.Arguments;
import leviathan143.loottweaker.common.lib.JsonConverter;
import leviathan143.loottweaker.common.zenscript.LootTweakerContext;
import leviathan143.loottweaker.common.zenscript.wrapper.ZenLootConditionWrapper;
import leviathan143.loottweaker.common.zenscript.wrapper.ZenLootFunctionWrapper;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;
import stanhebben.zenscript.annotations.ZenCaster;
import stanhebben.zenscript.annotations.ZenExpansion;

@ZenRegister
@ZenExpansion(value="any[any]")
public class JsonMapConversions {
    public static Impl IMPLEMENTATION = new Impl(LootTweaker.CONTEXT);

    @ZenCaster
    public static ZenLootConditionWrapper asLootCondition(Map<String, IData> json) {
        return IMPLEMENTATION.asLootCondition(json);
    }

    @ZenCaster
    public static ZenLootFunctionWrapper asLootFunction(Map<String, IData> json) {
        return IMPLEMENTATION.asLootFunction(json);
    }

    @VisibleForTesting
    public static class Impl {
        private final LootTweakerContext context;
        private final Gson lootDeserialiser = LootTableManagerAccessors.getGsonInstance();
        private final Gson jsonElementSerialiser = new GsonBuilder().registerTypeHierarchyAdapter(IData.class, (src, type, context) -> JsonConverter.from(src)).create();

        public Impl(LootTweakerContext context2) {
            this.context = context2;
        }

        @VisibleForTesting
        public ZenLootConditionWrapper asLootCondition(Map<String, ?> json) {
            return this.parse(json, LootCondition.class).map(ZenLootConditionWrapper::new).orElse(ZenLootConditionWrapper.INVALID);
        }

        @VisibleForTesting
        public ZenLootFunctionWrapper asLootFunction(Map<String, ?> json) {
            return this.parse(json, LootFunction.class).map(fn -> new ZenLootFunctionWrapper((LootFunction)fn, this.context)).orElse(ZenLootFunctionWrapper.INVALID);
        }

        private <T> Optional<T> parse(Map<String, ?> data, Class<T> clazz) {
            if (!Arguments.nonNull(this.context.getErrorHandler(), "json", data)) {
                return Optional.empty();
            }
            try {
                return Optional.of(this.lootDeserialiser.fromJson(this.jsonElementSerialiser.toJsonTree(data), clazz));
            }
            catch (JsonSyntaxException e) {
                this.context.getErrorHandler().error(e.getMessage());
                return Optional.empty();
            }
        }
    }
}

