/*
 * Decompiled with CFR 0.152.
 */
package leviathan143.loottweaker.common.lib;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import leviathan143.loottweaker.common.darkmagic.LootFunctionManagerAccessors;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraft.world.storage.loot.functions.LootFunctionManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RobustLootFunctionSerialiser
implements JsonSerializer<LootFunction> {
    private static final Logger SANITY_LOGGER = LogManager.getLogger((String)"loottweaker.sanity_checks");
    private final JsonSerializer<LootFunction> vanilla = new LootFunctionManager.Serializer();

    public JsonElement serialize(LootFunction function, Type type, JsonSerializationContext context) {
        if (this.checkSerialisable(function)) {
            return this.vanilla.serialize((Object)function, type, context);
        }
        JsonObject json = new JsonObject();
        json.addProperty("_comment", "A best effort serialisation of a non-serialisable loot function");
        json.addProperty("class", function.getClass().getName());
        if (function.func_186554_a() != null && function.func_186554_a().length > 0) {
            json.add("conditions", context.serialize((Object)function.func_186554_a()));
        }
        return json;
    }

    private boolean checkSerialisable(LootFunction function) {
        if (LootFunctionManagerAccessors.getClassToSerialiserMap().containsKey(function.getClass())) {
            return true;
        }
        SANITY_LOGGER.error("No serialiser registered for loot function {}", (Object)function.getClass().getName());
        return false;
    }
}

