/*
 * Decompiled with CFR 0.152.
 */
package levelup2.network;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Map;
import levelup2.LevelUp2;
import levelup2.api.IPlayerSkill;
import levelup2.config.LevelUpConfig;
import levelup2.player.IPlayerClass;
import levelup2.skills.SkillRegistry;
import levelup2.util.SkillProperties;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.INetHandler;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.FMLEventChannel;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.internal.FMLProxyPacket;
import net.minecraftforge.fml.relauncher.Side;

public class SkillPacketHandler {
    public static final String[] CHANNELS = new String[]{"levelupinit", "levelupclasses", "levelupskills", "levelupcfg", "levelupproperties", "leveluprefresh"};
    public static FMLEventChannel initChannel;
    public static FMLEventChannel classChannel;
    public static FMLEventChannel skillChannel;
    public static FMLEventChannel configChannel;
    public static FMLEventChannel propertyChannel;
    public static FMLEventChannel refreshChannel;

    public static void init() {
        SkillPacketHandler handler = new SkillPacketHandler();
        initChannel = NetworkRegistry.INSTANCE.newEventDrivenChannel(CHANNELS[0]);
        initChannel.register((Object)handler);
        classChannel = NetworkRegistry.INSTANCE.newEventDrivenChannel(CHANNELS[1]);
        classChannel.register((Object)handler);
        skillChannel = NetworkRegistry.INSTANCE.newEventDrivenChannel(CHANNELS[2]);
        skillChannel.register((Object)handler);
        configChannel = NetworkRegistry.INSTANCE.newEventDrivenChannel(CHANNELS[3]);
        configChannel.register((Object)handler);
        propertyChannel = NetworkRegistry.INSTANCE.newEventDrivenChannel(CHANNELS[4]);
        propertyChannel.register((Object)handler);
        refreshChannel = NetworkRegistry.INSTANCE.newEventDrivenChannel(CHANNELS[5]);
        refreshChannel.register((Object)handler);
        MinecraftForge.EVENT_BUS.register((Object)handler);
    }

    @SubscribeEvent
    public void onServerPacket(FMLNetworkEvent.ServerCustomPacketEvent evt) {
        ByteBuf in = evt.getPacket().payload();
        EntityPlayerMP player = ((NetHandlerPlayServer)evt.getHandler()).field_147369_b;
        if (evt.getPacket().channel().equals(CHANNELS[1])) {
            this.addTask(evt.getHandler(), () -> this.handleClassChange(in.readByte(), in.readBoolean(), player));
        } else if (evt.getPacket().channel().equals(CHANNELS[2])) {
            this.addTask(evt.getHandler(), () -> this.handlePacket(in, (EntityPlayer)player));
        }
    }

    @SubscribeEvent
    public void onClientPacket(FMLNetworkEvent.ClientCustomPacketEvent evt) {
        ByteBuf in = evt.getPacket().payload();
        if (evt.getPacket().channel().equals(CHANNELS[0])) {
            this.addTask(evt.getHandler(), () -> this.handlePacket(in, LevelUp2.proxy.getPlayer()));
        } else if (evt.getPacket().channel().equals(CHANNELS[3])) {
            this.addTask(evt.getHandler(), () -> this.handleConfig(in));
        } else if (evt.getPacket().channel().equals(CHANNELS[4])) {
            this.addTask(evt.getHandler(), () -> this.handleProperties(in));
        } else if (evt.getPacket().channel().equals(CHANNELS[5])) {
            this.addTask(evt.getHandler(), () -> this.refreshValues());
        }
    }

    private void addTask(INetHandler netHandler, Runnable runnable) {
        FMLCommonHandler.instance().getWorldThread(netHandler).func_152344_a(runnable);
    }

    private void handleClassChange(byte newClass, boolean reclass, EntityPlayerMP player) {
        if (newClass >= 0 && SkillRegistry.getPlayer((EntityPlayer)player).getSpecialization() != newClass) {
            if (LevelUpConfig.reclassCost > 0 && reclass) {
                player.func_82242_a(-LevelUpConfig.reclassCost);
            }
            SkillRegistry.getPlayer((EntityPlayer)player).setSpecialization(newClass);
            SkillRegistry.loadPlayer((EntityPlayer)player);
        }
    }

    private void handlePacket(ByteBuf buf, EntityPlayer player) {
        boolean isInit = player.field_70170_p.field_72995_K;
        byte button = buf.readByte();
        int levelSpend = buf.readInt();
        String[] skills = null;
        int[] data = null;
        if (isInit || button == -1) {
            data = new int[SkillRegistry.getSkillRegistry().size()];
            skills = new String[SkillRegistry.getSkillRegistry().size()];
            for (int i = 0; i < data.length; ++i) {
                skills[i] = ByteBufUtils.readUTF8String((ByteBuf)buf);
                data[i] = buf.readInt();
            }
        }
        IPlayerClass properties = SkillRegistry.getPlayer(player);
        if (!isInit) {
            if (data != null && button == -1) {
                for (int i = 0; i < data.length; ++i) {
                    properties.setSkillLevel(skills[i], data[i]);
                }
                SkillRegistry.loadPlayer(player);
            }
        } else if (data != null) {
            properties.setSpecialization(button);
            properties.setPlayerData(skills, data);
        }
        if (levelSpend > 0) {
            player.func_82242_a(-levelSpend);
        }
    }

    public static FMLProxyPacket getPacket(Side side, int channel, byte ID, Object ... data) {
        ByteBuf buf = Unpooled.buffer();
        buf.writeByte((int)ID);
        if ((ID < 0 || channel == 0) && data != null) {
            Object map;
            if (data.length == 1 && data[0] instanceof Map) {
                map = (Map)data[0];
                buf.writeInt(0);
                for (String str : map.keySet()) {
                    ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)str);
                    buf.writeInt(((Integer)map.get(str)).intValue());
                }
            } else if (data.length == 2 && data[0] instanceof Map && data[1] instanceof Integer) {
                buf.writeInt(((Integer)data[1]).intValue());
                map = (Map)data[0];
                for (String str : map.keySet()) {
                    ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)str);
                    buf.writeInt(((Integer)map.get(str)).intValue());
                }
            } else {
                for (Object dat : data) {
                    if (dat instanceof String) {
                        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)((String)dat));
                        continue;
                    }
                    if (!(dat instanceof Integer)) continue;
                    buf.writeInt(((Integer)dat).intValue());
                }
            }
        } else if (channel == 1) {
            if (data != null && data[0] != null && data[0] instanceof Boolean) {
                buf.writeBoolean(((Boolean)data[0]).booleanValue());
            } else {
                buf.writeBoolean(false);
            }
        }
        FMLProxyPacket pkt = new FMLProxyPacket(new PacketBuffer(buf), CHANNELS[channel]);
        pkt.setTarget(side);
        return pkt;
    }

    public static FMLProxyPacket getConfigPacket(Property ... dat) {
        ByteBuf buf = Unpooled.buffer();
        for (int i = 0; i < dat.length; ++i) {
            buf.writeBoolean(dat[i].getBoolean());
        }
        FMLProxyPacket pkt = new FMLProxyPacket(new PacketBuffer(buf), CHANNELS[3]);
        pkt.setTarget(Side.CLIENT);
        return pkt;
    }

    private void handleConfig(ByteBuf buf) {
        Property[] properties = LevelUpConfig.getServerProperties();
        for (int i = 0; i < properties.length; ++i) {
            properties[i].set(buf.readBoolean());
        }
        LevelUpConfig.useServerProperties();
    }

    public static FMLProxyPacket getPropertyPackets(IPlayerSkill skill) {
        SkillProperties prop = SkillRegistry.getProperty(skill);
        ByteBuf buf = Unpooled.buffer();
        if (prop != null) {
            prop.writeToBytes(buf);
        }
        FMLProxyPacket pkt = new FMLProxyPacket(new PacketBuffer(buf), CHANNELS[4]);
        pkt.setTarget(Side.CLIENT);
        return pkt;
    }

    private void handleProperties(ByteBuf buf) {
        NBTTagCompound tag = ByteBufUtils.readTag((ByteBuf)buf);
        SkillProperties.fromNBT(tag);
    }

    public static FMLProxyPacket getRefreshPacket() {
        ByteBuf buf = Unpooled.buffer();
        buf.writeBoolean(true);
        FMLProxyPacket pkt = new FMLProxyPacket(new PacketBuffer(buf), CHANNELS[5]);
        pkt.setTarget(Side.CLIENT);
        return pkt;
    }

    private void refreshValues() {
        SkillRegistry.calculateHighLow();
    }
}

