/*
 * Decompiled with CFR 0.152.
 */
package net.theawesomegem.fishingmadebetter.common.item.tracker;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.theawesomegem.fishingmadebetter.common.capability.fishing.FishingCapabilityProvider;
import net.theawesomegem.fishingmadebetter.common.capability.fishing.IFishingData;
import net.theawesomegem.fishingmadebetter.common.data.FishData;
import net.theawesomegem.fishingmadebetter.common.registry.FMBCreativeTab;

public abstract class ItemFishTracker
extends Item {
    protected final TrackingVision trackingVision;
    protected final FishData.FishingLiquid trackingLiquid;
    protected final int maxDepth;

    public ItemFishTracker(TrackingVision trackingVision, FishData.FishingLiquid trackingLiquid, int maxDepth, String name) {
        this.func_77637_a(FMBCreativeTab.instance);
        this.setRegistryName(name);
        this.func_77655_b("fishingmadebetter." + name);
        this.trackingVision = trackingVision;
        this.trackingLiquid = trackingLiquid;
        this.maxDepth = maxDepth;
    }

    public TrackingVision getTrackingVision() {
        return this.trackingVision;
    }

    public int getMaxDepth() {
        return this.maxDepth;
    }

    public FishData.FishingLiquid getLiquidEnum() {
        return this.trackingLiquid;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        Material mat;
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        if (worldIn.field_72995_K) {
            return new ActionResult(EnumActionResult.FAIL, (Object)itemstack);
        }
        IFishingData fishingData = (IFishingData)playerIn.getCapability(FishingCapabilityProvider.FISHING_DATA_CAP, null);
        if (fishingData == null) {
            return new ActionResult(EnumActionResult.FAIL, (Object)itemstack);
        }
        if (fishingData.getTimeSinceTracking() > 0L) {
            return new ActionResult(EnumActionResult.FAIL, (Object)itemstack);
        }
        RayTraceResult raytraceresult = this.func_77621_a(worldIn, playerIn, true);
        if (raytraceresult == null) {
            return new ActionResult(EnumActionResult.PASS, (Object)itemstack);
        }
        if (raytraceresult.field_72313_a != RayTraceResult.Type.BLOCK) {
            return new ActionResult(EnumActionResult.PASS, (Object)itemstack);
        }
        BlockPos pos = raytraceresult.func_178782_a();
        IBlockState blockClicked = worldIn.func_180495_p(pos);
        if (this.trackingLiquid.equals((Object)FishData.FishingLiquid.VOID)) {
            if (pos.func_177956_o() > 3) {
                playerIn.func_145747_a((ITextComponent)new TextComponentTranslation("notif.fishingmadebetter.fish_tracker.only_void", new Object[0]));
                return new ActionResult(EnumActionResult.FAIL, (Object)itemstack);
            }
        } else if (this.trackingLiquid.equals((Object)FishData.FishingLiquid.WATER)) {
            if (blockClicked.func_185904_a() != Material.field_151586_h) {
                playerIn.func_145747_a((ITextComponent)new TextComponentTranslation("notif.fishingmadebetter.fish_tracker.only_water", new Object[0]));
                return new ActionResult(EnumActionResult.FAIL, (Object)itemstack);
            }
        } else if (this.trackingLiquid.equals((Object)FishData.FishingLiquid.LAVA) && blockClicked.func_185904_a() != Material.field_151587_i) {
            playerIn.func_145747_a((ITextComponent)new TextComponentTranslation("notif.fishingmadebetter.fish_tracker.only_lava", new Object[0]));
            return new ActionResult(EnumActionResult.FAIL, (Object)itemstack);
        }
        if (blockClicked.func_185904_a() == MaterialLiquid.field_151586_h) {
            int waterCount = 0;
            for (BlockPos posit : BlockPos.func_191532_a((int)(pos.func_177958_n() - 2), (int)(pos.func_177956_o() - 3), (int)(pos.func_177952_p() - 2), (int)(pos.func_177958_n() + 2), (int)pos.func_177956_o(), (int)(pos.func_177952_p() + 2))) {
                mat = worldIn.func_180495_p(posit).func_185904_a();
                if (mat == MaterialLiquid.field_151586_h) {
                    ++waterCount;
                }
                if (waterCount < 25) continue;
                break;
            }
            if (waterCount < 25) {
                playerIn.func_145747_a((ITextComponent)new TextComponentTranslation("notif.fishingmadebetter.fish_tracker.too_shallow", new Object[0]));
                return new ActionResult(EnumActionResult.FAIL, (Object)itemstack);
            }
        }
        if (blockClicked.func_185904_a() == MaterialLiquid.field_151587_i) {
            int lavaCount = 0;
            for (BlockPos posit : BlockPos.func_191532_a((int)(pos.func_177958_n() - 2), (int)(pos.func_177956_o() - 3), (int)(pos.func_177952_p() - 2), (int)(pos.func_177958_n() + 2), (int)pos.func_177956_o(), (int)(pos.func_177952_p() + 2))) {
                mat = worldIn.func_180495_p(posit).func_185904_a();
                if (mat == MaterialLiquid.field_151587_i) {
                    ++lavaCount;
                }
                if (lavaCount < 25) continue;
                break;
            }
            if (lavaCount < 25) {
                playerIn.func_145747_a((ITextComponent)new TextComponentTranslation("notif.fishingmadebetter.fish_tracker.too_shallow", new Object[0]));
                return new ActionResult(EnumActionResult.FAIL, (Object)itemstack);
            }
        }
        playerIn.func_145747_a((ITextComponent)new TextComponentTranslation("notif.fishingmadebetter.fish_tracker.tracking_start", new Object[0]));
        fishingData.setTimeSinceTracking(playerIn.field_70170_p.func_82737_E());
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(I18n.func_135052_a((String)"item.fishingmadebetter.fish_tracker.tooltip.max_depth", (Object[])new Object[0]) + ": " + this.maxDepth);
        String rarityText = TrackingVision.BAD.equals((Object)this.getTrackingVision()) ? "item.fishingmadebetter.fish_tracker.tooltip.vision_bad" : (TrackingVision.NORMAL.equals((Object)this.getTrackingVision()) ? "item.fishingmadebetter.fish_tracker.tooltip.vision_normal" : (TrackingVision.BEST.equals((Object)this.getTrackingVision()) ? "item.fishingmadebetter.fish_tracker.tooltip.vision_best" : "item.fishingmadebetter.fish_tracker.tooltip.vision_none"));
        tooltip.add(I18n.func_135052_a((String)rarityText, (Object[])new Object[0]));
        String liquidText = FishData.FishingLiquid.WATER.equals((Object)this.getLiquidEnum()) ? "item.fishingmadebetter.fish_tracker.tooltip.probe_water" : (FishData.FishingLiquid.LAVA.equals((Object)this.getLiquidEnum()) ? "item.fishingmadebetter.fish_tracker.tooltip.probe_lava" : (FishData.FishingLiquid.VOID.equals((Object)this.getLiquidEnum()) ? "item.fishingmadebetter.fish_tracker.tooltip.probe_void" : "item.fishingmadebetter.fish_tracker.tooltip.probe_etc"));
        tooltip.add(I18n.func_135052_a((String)liquidText, (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"item.fishingmadebetter.fish_tracker.tooltip.right_click", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"item.fishingmadebetter.fish_tracker.tooltip.info.1", (Object[])new Object[0]) + " " + TextFormatting.GOLD + Minecraft.func_71410_x().field_71474_y.field_74311_E.getDisplayName() + TextFormatting.RESET + "" + TextFormatting.GRAY + " " + I18n.func_135052_a((String)"item.fishingmadebetter.fish_tracker.tooltip.info.2", (Object[])new Object[0]) + TextFormatting.RESET);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerItemModel(Item item) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation("fishingmadebetter:tracker/" + this.getRegistryName().func_110623_a(), "inventory"));
    }

    public static enum TrackingVision {
        BAD,
        NORMAL,
        BEST;


        public static int getMinRarity(TrackingVision enumTracking) {
            switch (enumTracking) {
                case BAD: {
                    return 40;
                }
                case NORMAL: {
                    return 20;
                }
                case BEST: {
                    return 0;
                }
            }
            return 40;
        }
    }
}

