/*
 * Decompiled with CFR 0.152.
 */
package net.theawesomegem.fishingmadebetter.common.block.tileentity;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.theawesomegem.fishingmadebetter.BetterFishUtil;
import net.theawesomegem.fishingmadebetter.common.capability.world.ChunkCapabilityProvider;
import net.theawesomegem.fishingmadebetter.common.capability.world.IChunkFishingData;
import net.theawesomegem.fishingmadebetter.common.capability.world.PopulationData;
import net.theawesomegem.fishingmadebetter.common.configuration.ConfigurationManager;
import net.theawesomegem.fishingmadebetter.common.configuration.CustomConfigurationHandler;
import net.theawesomegem.fishingmadebetter.common.data.FishData;
import net.theawesomegem.fishingmadebetter.util.TimeUtil;

public class TileEntityBaitBox
extends TileEntity
implements ITickable {
    private long baitUpdateTime;
    private int timer = 0;
    private ItemStackHandler inventory = new ItemStackHandler(8);

    public void onLoad() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.updateBaitTime(this.field_145850_b.func_82737_E());
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.timer % 20 == 0) {
            this.timer = 0;
        }
        if (this.timer == 0) {
            this.updateOnSecond(this.field_145850_b.func_82737_E());
        }
        ++this.timer;
    }

    public void handleRightClick(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
        ItemStack itemStack = player.func_184614_ca();
        if (!itemStack.func_190926_b()) {
            int freeSlot = -1;
            if (!BetterFishUtil.isValidBait(itemStack)) {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("notif.fishingmadebetter.baitbox.bait_not_valid", new Object[0]));
                return;
            }
            for (int i = 0; i < this.inventory.getSlots() && itemStack.func_190916_E() > 0; ++i) {
                ItemStack stack = this.inventory.getStackInSlot(i);
                if (stack.func_190926_b()) {
                    freeSlot = i;
                    continue;
                }
                if (!this.isItemStackEqual(itemStack, stack) || stack.func_77976_d() - stack.func_190916_E() <= 0) continue;
                itemStack = this.inventory.insertItem(i, itemStack, false);
            }
            if (itemStack.func_190916_E() > 0 && freeSlot != -1) {
                itemStack = this.inventory.insertItem(freeSlot, itemStack, false);
            }
            if (itemStack.func_190916_E() > 0) {
                player.func_184611_a(EnumHand.MAIN_HAND, itemStack);
                player.func_145747_a((ITextComponent)new TextComponentTranslation("notif.fishingmadebetter.baitbox.full", new Object[0]));
            } else {
                player.func_184611_a(EnumHand.MAIN_HAND, ItemStack.field_190927_a);
            }
            return;
        }
        HashMap<String, Integer> baitAmountMap = new HashMap<String, Integer>();
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            ItemStack stack = this.inventory.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            String name = stack.func_82833_r();
            if (baitAmountMap.containsKey(name)) {
                baitAmountMap.put(name, (Integer)baitAmountMap.get(name) + stack.func_190916_E());
                continue;
            }
            baitAmountMap.put(name, stack.func_190916_E());
        }
        if (baitAmountMap.isEmpty()) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("notif.fishingmadebetter.baitbox.empty", new Object[0]));
        } else {
            for (Map.Entry baitEntry : baitAmountMap.entrySet()) {
                player.func_145747_a((ITextComponent)new TextComponentString(String.format("%s: %d", baitEntry.getKey(), baitEntry.getValue())));
            }
        }
    }

    private void updateOnSecond(long worldTime) {
        if (worldTime > this.baitUpdateTime) {
            IChunkFishingData chunkFishingData = (IChunkFishingData)this.field_145850_b.func_175726_f(this.func_174877_v()).getCapability(ChunkCapabilityProvider.CHUNK_FISHING_DATA_CAP, null);
            if (chunkFishingData == null) {
                return;
            }
            this.updateBaitTime(worldTime);
            for (PopulationData populationData : chunkFishingData.getFishes(worldTime).values()) {
                FishData fishData;
                if (!populationData.isHungry(worldTime) || (fishData = CustomConfigurationHandler.fishDataMap.get(populationData.getFishType())) == null) continue;
                this.checkBait(fishData.baitItemMap, populationData.getQuantity(), populationData, worldTime, (fishData.maxWeight + fishData.minWeight) / 2);
            }
        }
    }

    private boolean isItemStackEqual(ItemStack itemStack, ItemStack other) {
        if (!ItemStack.func_179545_c((ItemStack)itemStack, (ItemStack)other)) {
            return false;
        }
        if (itemStack.func_77978_p() == null && other.func_77978_p() != null) {
            return false;
        }
        return (itemStack.func_77978_p() == null || itemStack.func_77978_p().equals((Object)other.func_77978_p())) && itemStack.areCapsCompatible(other);
    }

    private void updateBaitTime(long worldTime) {
        this.baitUpdateTime = worldTime + TimeUtil.minutesToMinecraftTicks(ConfigurationManager.server.baitBoxUpdateInterval);
    }

    private void checkBait(Map<String, Integer[]> baitItemMap, int population, PopulationData populationData, long worldTime, int avgWeight) {
        if (population < 2) {
            return;
        }
        int itemsLeft = Math.min(16, Math.max(1, avgWeight / 100));
        for (int i = 0; i < this.inventory.getSlots() && itemsLeft > 0; ++i) {
            ItemStack itemStack = this.inventory.getStackInSlot(i);
            if (itemStack.func_190926_b()) continue;
            String id = itemStack.func_77973_b().getRegistryName().toString();
            if (!ConfigurationManager.server.simpleBait && (!baitItemMap.containsKey(id) || !Arrays.asList((Object[])baitItemMap.get(id)).contains(itemStack.func_77960_j()))) continue;
            int itemsToTake = itemsLeft > itemStack.func_190916_E() ? itemStack.func_190916_E() : itemsLeft;
            itemsLeft -= itemsToTake;
            this.inventory.extractItem(i, itemsToTake, false);
        }
        if (itemsLeft <= 0) {
            populationData.setLastEatenTime(worldTime);
        }
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)(capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY ? this.inventory : super.getCapability(capability, facing));
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74772_a("baitUpdateTime", this.baitUpdateTime);
        compound.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
        return super.func_189515_b(compound);
    }

    public void func_145839_a(NBTTagCompound compound) {
        this.baitUpdateTime = compound.func_74763_f("baitUpdateTime");
        this.inventory.deserializeNBT(compound.func_74775_l("inventory"));
        super.func_145839_a(compound);
    }
}

