/*
 * Decompiled with CFR 0.152.
 */
package familiarfauna.item;

import familiarfauna.entities.EntityButterfly;
import familiarfauna.entities.EntityDragonfly;
import familiarfauna.entities.EntityPixie;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemBugHabitat
extends Item {
    public ItemBugHabitat() {
        this.func_185043_a(new ResourceLocation("bug"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(@Nonnull ItemStack stack, World world, EntityLivingBase entity) {
                if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("Bug")) {
                    if (stack.func_77978_p().func_74779_i("Bug").equals("butterfly")) {
                        return 1.0f;
                    }
                    if (stack.func_77978_p().func_74779_i("Bug").equals("dragonfly")) {
                        return 2.0f;
                    }
                    if (stack.func_77978_p().func_74779_i("Bug").equals("pixie")) {
                        return 3.0f;
                    }
                }
                return 0.0f;
            }
        });
        this.func_185043_a(new ResourceLocation("variant"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(@Nonnull ItemStack stack, World world, EntityLivingBase entity) {
                if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("Bug")) {
                    if (stack.func_77978_p().func_74779_i("Bug").equals("butterfly")) {
                        if (stack.func_77978_p().func_74764_b("Type")) {
                            return stack.func_77978_p().func_74762_e("Type") + 1;
                        }
                        return 1.0f;
                    }
                    if (stack.func_77978_p().func_74779_i("Bug").equals("dragonfly")) {
                        if (stack.func_77978_p().func_74764_b("Type")) {
                            return stack.func_77978_p().func_74762_e("Type") + 1;
                        }
                        return 1.0f;
                    }
                    if (stack.func_77978_p().func_74779_i("Bug").equals("pixie")) {
                        if (stack.func_77978_p().func_74764_b("Type")) {
                            return stack.func_77978_p().func_74762_e("Type") + 1;
                        }
                        return 1.0f;
                    }
                }
                return 0.0f;
            }
        });
        this.field_77777_bU = 1;
    }

    public String func_77667_c(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("Bug") && !stack.func_77978_p().func_74764_b("Name")) {
            return super.func_77658_a() + "_" + stack.func_77978_p().func_74779_i("Bug");
        }
        return super.func_77658_a();
    }

    public String func_77653_i(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("Name")) {
            String name = stack.func_77978_p().func_74779_i("Name");
            return I18n.func_74838_a((String)(this.func_77657_g(stack) + ".name")).trim() + " - " + TextFormatting.ITALIC + name + TextFormatting.RESET;
        }
        return I18n.func_74838_a((String)(this.func_77657_g(stack) + ".name")).trim();
    }

    protected Vec3d getAirPositionInFrontOfPlayer(World world, EntityPlayer player, double targetDistance) {
        float cosYaw = MathHelper.func_76134_b((float)(-player.field_70177_z * ((float)Math.PI / 180) - (float)Math.PI));
        float sinYaw = MathHelper.func_76126_a((float)(-player.field_70177_z * ((float)Math.PI / 180) - (float)Math.PI));
        float cosPitch = -MathHelper.func_76134_b((float)(-player.field_70125_A * ((float)Math.PI / 180)));
        float facingX = sinYaw * cosPitch;
        float facingY = MathHelper.func_76126_a((float)(-player.field_70125_A * ((float)Math.PI / 180)));
        float facingZ = cosYaw * cosPitch;
        Vec3d playerEyePosition = new Vec3d(player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v);
        Vec3d targetPosition = playerEyePosition.func_72441_c((double)facingX * targetDistance, (double)facingY * targetDistance, (double)facingZ * targetDistance);
        RayTraceResult hit = this.func_77621_a(world, player, true);
        if (hit == null) {
            return targetPosition;
        }
        double distance = playerEyePosition.func_72438_d(hit.field_72307_f) * 0.9;
        return playerEyePosition.func_72441_c((double)facingX * distance, (double)facingY * distance, (double)facingZ * distance);
    }

    public boolean releaseBug(ItemStack stack, World world, EntityPlayer player, EnumHand hand, Vec3d releasePoint) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("Bug") && !world.field_72995_K) {
            String bugEntity = stack.func_77978_p().func_74779_i("Bug");
            String bugName = "";
            int bugType = 0;
            if (stack.func_77978_p().func_74764_b("Name")) {
                bugName = stack.func_77978_p().func_74779_i("Name");
            }
            if (stack.func_77978_p().func_74764_b("Type")) {
                bugType = stack.func_77978_p().func_74762_e("Type");
            }
            if (bugEntity.equals("butterfly")) {
                EntityButterfly butterfly = new EntityButterfly(world);
                butterfly.setButterflyType(bugType);
                butterfly.func_70012_b(releasePoint.field_72450_a, releasePoint.field_72448_b, releasePoint.field_72449_c, MathHelper.func_76142_g((float)(world.field_73012_v.nextFloat() * 360.0f)), 0.0f);
                if (bugName != "") {
                    butterfly.func_96094_a(bugName);
                }
                world.func_72838_d((Entity)butterfly);
            }
            if (bugEntity.equals("dragonfly")) {
                EntityDragonfly dragonfly = new EntityDragonfly(world);
                dragonfly.setDragonflyType(bugType);
                dragonfly.func_70012_b(releasePoint.field_72450_a, releasePoint.field_72448_b, releasePoint.field_72449_c, MathHelper.func_76142_g((float)(world.field_73012_v.nextFloat() * 360.0f)), 0.0f);
                if (bugName != "") {
                    dragonfly.func_96094_a(bugName);
                }
                world.func_72838_d((Entity)dragonfly);
            }
            if (bugEntity.equals("pixie")) {
                EntityPixie pixie = new EntityPixie(world);
                pixie.setPixieType(bugType);
                pixie.func_70012_b(releasePoint.field_72450_a, releasePoint.field_72448_b, releasePoint.field_72449_c, MathHelper.func_76142_g((float)(world.field_73012_v.nextFloat() * 360.0f)), 0.0f);
                if (bugName != "") {
                    pixie.func_96094_a(bugName);
                }
                world.func_72838_d((Entity)pixie);
            }
            stack.func_77978_p().func_82580_o("Bug");
            stack.func_77978_p().func_82580_o("Type");
            stack.func_77978_p().func_82580_o("Name");
            return true;
        }
        return false;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (world.field_72995_K) {
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }
        Vec3d releasePoint = this.getAirPositionInFrontOfPlayer(world, player, 2.0);
        return this.releaseBug(stack, world, player, hand, releasePoint) ? new ActionResult(EnumActionResult.SUCCESS, (Object)stack) : new ActionResult(EnumActionResult.FAIL, (Object)stack);
    }
}

